/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.util.listenable;

import com.ochafik.util.listenable.CollectionListener;
import com.ochafik.util.listenable.ListenableCollection;
import com.ochafik.util.listenable.ListenableSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultListenableCollection<T>
implements ListenableCollection<T> {
    protected Collection<T> collection;
    protected ListenableSupport<T> collectionSupport;

    @Override
    public void addCollectionListener(CollectionListener<T> l) {
        this.collectionSupport.addCollectionListener(l);
    }

    @Override
    public void removeCollectionListener(CollectionListener<T> l) {
        this.collectionSupport.removeCollectionListener(l);
    }

    public DefaultListenableCollection(Collection<T> collection) {
        this(collection, new ListenableSupport());
    }

    public DefaultListenableCollection(Collection<T> collection, ListenableSupport<T> collectionSupport) {
        this.collection = collection;
        this.collectionSupport = collectionSupport;
    }

    @Override
    public boolean add(T o) {
        int index;
        boolean added = this.collection.add(o);
        int n = index = this.collection instanceof List ? this.size() : -1;
        if (added) {
            this.collectionSupport.fireAdded(this, Collections.singleton(o), index, index);
        } else {
            this.collectionSupport.fireUpdated(this, Collections.singleton(o), index, index);
        }
        return added;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        if (!this.collectionSupport.hasListeners()) {
            return this.collection.addAll(c);
        }
        int max = c.size();
        ArrayList<T> addedElements = new ArrayList<T>(max);
        ArrayList updatedElements = new ArrayList(max);
        for (T t : c) {
            (this.collection.add(t) ? addedElements : updatedElements).add(t);
        }
        int firstIndex = this.collection instanceof List ? this.size() : -1;
        int lastIndex = firstIndex < 0 ? -1 : firstIndex + addedElements.size() - 1;
        this.collectionSupport.fireAdded(this, addedElements, firstIndex, lastIndex);
        this.collectionSupport.fireUpdated(this, updatedElements, firstIndex, lastIndex);
        return !addedElements.isEmpty();
    }

    @Override
    public void clear() {
        if (!this.collectionSupport.hasListeners()) {
            this.collection.clear();
            return;
        }
        ArrayList<T> copy = new ArrayList<T>(this.collection);
        this.collection.clear();
        this.collectionSupport.fireRemoved(this, copy);
    }

    @Override
    public boolean contains(Object o) {
        return this.collection.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.collection.containsAll(c);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return ((Object)this.collection).equals(obj);
    }

    @Override
    public int hashCode() {
        return ((Object)this.collection).hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.collection.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return new ListenableIterator(this, this.collection.iterator());
    }

    @Override
    public boolean remove(Object o) {
        boolean removed = this.collection.remove(o);
        if (removed) {
            this.collectionSupport.fireRemoved(this, Collections.singleton(o));
        }
        return removed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (!this.collectionSupport.hasListeners()) {
            return this.collection.removeAll(c);
        }
        ArrayList removedElements = new ArrayList(c.size());
        for (Object t : c) {
            boolean removed = this.collection.remove(t);
            if (!removed) continue;
            removedElements.add(t);
        }
        this.collectionSupport.fireRemoved(this, removedElements);
        return !removedElements.isEmpty();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (!this.collectionSupport.hasListeners()) {
            return this.collection.retainAll(c);
        }
        ArrayList<T> removedElements = new ArrayList<T>(c.size());
        Iterator<T> it = this.iterator();
        while (it.hasNext()) {
            T e = it.next();
            if (c.contains(e)) continue;
            it.remove();
            removedElements.add(e);
        }
        this.collectionSupport.fireRemoved(this, removedElements);
        return !removedElements.isEmpty();
    }

    @Override
    public int size() {
        return this.collection.size();
    }

    @Override
    public Object[] toArray() {
        return this.collection.toArray();
    }

    @Override
    public <V> V[] toArray(V[] a) {
        return this.collection.toArray(a);
    }

    public String toString() {
        return this.collection.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ListenableIterator
    implements Iterator<T> {
        Iterator<T> iterator;
        T lastValue;
        DefaultListenableCollection<T> listenableCollection;

        public ListenableIterator(DefaultListenableCollection<T> listenableCollection, Iterator<T> iterator) {
            this.iterator = iterator;
            this.listenableCollection = listenableCollection;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            this.lastValue = this.iterator.next();
            return this.lastValue;
        }

        @Override
        public void remove() {
            this.iterator.remove();
            DefaultListenableCollection.this.collectionSupport.fireRemoved(this.listenableCollection, Collections.singleton(this.lastValue));
        }
    }
}

