/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.xml;

import com.ochafik.util.listenable.Adapter;
import com.ochafik.util.string.RegexUtils;
import java.io.File;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLUtils {
    static TransformerFactory tFactory = TransformerFactory.newInstance();
    private static final Pattern xmlTagPattern = Pattern.compile("<!--.*?-->|</?\\w+[^\">]*(?:(?:\"[^\"]*\")[\">]*)*>");
    private static final Pattern spacesPattern = Pattern.compile("\\s+");
    private static final MessageFormat spaceMessageFormat = new MessageFormat(" ");

    public static String getAttribute(Node node, String name) {
        NamedNodeMap m = node.getAttributes();
        if (m == null) {
            return null;
        }
        Node att = m.getNamedItem(name);
        if (att == null) {
            return null;
        }
        return att.getNodeValue();
    }

    public static Node getFirstNamedNode(Node node, String name) {
        if (node.getNodeName().equalsIgnoreCase(name)) {
            return node;
        }
        NodeList list = node.getChildNodes();
        int len = list.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = XMLUtils.getFirstNamedNode(list.item(i), name);
            if (n == null) continue;
            return n;
        }
        return null;
    }

    public static List<Node> getByName(Node node, String name) {
        LinkedList<Node> result = new LinkedList<Node>();
        XMLUtils.getByName(node, name, result);
        return result;
    }

    private static void getByName(Node node, String name, List<Node> result) {
        if (node.getNodeName().equalsIgnoreCase(name)) {
            result.add(node);
        } else {
            NodeList list = node.getChildNodes();
            int len = list.getLength();
            for (int i = 0; i < len; ++i) {
                XMLUtils.getByName(list.item(i), name, result);
            }
        }
    }

    public static Collection<Node> getChildrenByName(Node node, String name) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        XMLUtils.getChildrenByName(node, name, nodes);
        return nodes;
    }

    private static void getChildrenByName(Node node, String name, Collection<Node> nodes) {
        NodeList list = node.getChildNodes();
        int len = list.getLength();
        for (int i = 0; i < len; ++i) {
            Node child = list.item(i);
            if (!child.getNodeName().equalsIgnoreCase(name)) continue;
            nodes.add(child);
        }
    }

    public static List<Node> getChildElements(Node node) {
        NodeList children = node.getChildNodes();
        int childCount = children.getLength();
        ArrayList<Node> nodes = new ArrayList<Node>(childCount);
        for (int i = 0; i < childCount; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            nodes.add(child);
        }
        return nodes;
    }

    public static List<Node> getAttributes(Node node) {
        NamedNodeMap attrs = node.getAttributes();
        int attrCount = attrs.getLength();
        ArrayList<Node> nodes = new ArrayList<Node>(attrCount);
        for (int i = 0; i < attrCount; ++i) {
            nodes.add(attrs.item(i));
        }
        return nodes;
    }

    public static StringBuffer gatherTextPCDATAAndCDATADescendants(Node node, StringBuffer sb, String separator) {
        short t;
        if (sb == null) {
            sb = new StringBuffer();
        }
        if ((t = node.getNodeType()) == 4 || t == 3) {
            sb.append(node.getNodeValue());
        } else {
            NodeList list = node.getChildNodes();
            int len = list.getLength();
            for (int i = 0; i < len; ++i) {
                Node n = list.item(i);
                XMLUtils.gatherTextPCDATAAndCDATADescendants(n, sb, separator);
                if (i >= len - 1) continue;
                sb.append(separator);
            }
        }
        return sb;
    }

    public static String nodeToString(Node node) {
        try {
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(node);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            transformer.transform(source, result);
            return writer.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static final String escapeEntities(String s) {
        return s.replace("&", "&amp;").replace("<", "&lt;");
    }

    public static String stripTags(String xmlString) {
        String strippedHtml = RegexUtils.regexReplace(xmlTagPattern, xmlString, (Adapter<String[], String>)null);
        return RegexUtils.regexReplace(spacesPattern, strippedHtml, spaceMessageFormat).trim();
    }

    public static Document readXML(File file) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(file);
    }

    public static List<Node> list(NodeList nodeList) {
        if (nodeList == null) {
            return null;
        }
        int len = nodeList.getLength();
        ArrayList<Node> list = new ArrayList<Node>(len);
        for (int i = 0; i < len; ++i) {
            list.add(nodeList.item(i));
        }
        return list;
    }
}

