/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.screens.service;

import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

/**
 * Provides the remote service utility for ScreensAssetEntry. This utility wraps
 * <code>com.liferay.screens.service.impl.ScreensAssetEntryServiceImpl</code> and is an
 * access point for service operations in application layer code running on a
 * remote server. Methods of this service are expected to have security checks
 * based on the propagated JAAS credentials because this service can be
 * accessed remotely.
 *
 * @author José Manuel Navarro
 * @see ScreensAssetEntryService
 * @generated
 */
public class ScreensAssetEntryServiceUtil {

	/**
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify this class directly. Add custom service methods to <code>com.liferay.screens.service.impl.ScreensAssetEntryServiceImpl</code> and rerun ServiceBuilder to regenerate this class.
	 */

	/**
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. Always use {@link ScreensAssetEntryServiceUtil} to access the screens asset entry remote service. Add custom service methods to <code>com.liferay.screens.service.impl.ScreensAssetEntryServiceImpl</code> and rerun ServiceBuilder to automatically copy the method declarations to this interface.
	 */
	public static com.liferay.portal.kernel.json.JSONArray getAssetEntries(
			com.liferay.asset.kernel.service.persistence.AssetEntryQuery
				assetEntryQuery,
			java.util.Locale locale)
		throws com.liferay.portal.kernel.exception.PortalException {

		return getService().getAssetEntries(assetEntryQuery, locale);
	}

	public static com.liferay.portal.kernel.json.JSONArray getAssetEntries(
			long companyId, long groupId, String portletItemName,
			java.util.Locale locale, int max)
		throws com.liferay.portal.kernel.exception.PortalException {

		return getService().getAssetEntries(
			companyId, groupId, portletItemName, locale, max);
	}

	public static com.liferay.portal.kernel.json.JSONObject getAssetEntry(
			long entryId, java.util.Locale locale)
		throws com.liferay.portal.kernel.exception.PortalException {

		return getService().getAssetEntry(entryId, locale);
	}

	public static com.liferay.portal.kernel.json.JSONObject getAssetEntry(
			String className, long classPK, java.util.Locale locale)
		throws com.liferay.portal.kernel.exception.PortalException {

		return getService().getAssetEntry(className, classPK, locale);
	}

	/**
	 * Returns the OSGi service identifier.
	 *
	 * @return the OSGi service identifier
	 */
	public static String getOSGiServiceIdentifier() {
		return getService().getOSGiServiceIdentifier();
	}

	public static ScreensAssetEntryService getService() {
		return _serviceTracker.getService();
	}

	private static ServiceTracker
		<ScreensAssetEntryService, ScreensAssetEntryService> _serviceTracker;

	static {
		Bundle bundle = FrameworkUtil.getBundle(ScreensAssetEntryService.class);

		ServiceTracker<ScreensAssetEntryService, ScreensAssetEntryService>
			serviceTracker =
				new ServiceTracker
					<ScreensAssetEntryService, ScreensAssetEntryService>(
						bundle.getBundleContext(),
						ScreensAssetEntryService.class, null);

		serviceTracker.open();

		_serviceTracker = serviceTracker;
	}

}