/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.screens.service.impl;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.persistence.AssetEntryQuery;
import com.liferay.asset.publisher.web.util.AssetPublisherUtil;
import com.liferay.blogs.kernel.model.BlogsEntry;
import com.liferay.blogs.kernel.service.BlogsEntryService;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalArticleResource;
import com.liferay.journal.service.permission.JournalArticlePermission;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.PortletItem;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.spring.extender.service.ServiceReference;
import com.liferay.portlet.asset.service.permission.AssetEntryPermission;
import com.liferay.screens.service.base.ScreensAssetEntryServiceBaseImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletPreferences;

public class ScreensAssetEntryServiceImpl
extends ScreensAssetEntryServiceBaseImpl {
    @ServiceReference(type=BlogsEntryService.class)
    private BlogsEntryService _blogsEntryService;

    public JSONArray getAssetEntries(AssetEntryQuery assetEntryQuery, Locale locale) throws PortalException {
        List<AssetEntry> assetEntries = this.assetEntryLocalService.getEntries(assetEntryQuery);
        assetEntries = this.filterAssetEntries(assetEntries);
        return this.toJSONArray(assetEntries, locale);
    }

    public JSONArray getAssetEntries(long companyId, long groupId, String portletItemName, Locale locale, int max) throws PortalException {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(PortletItem.class);
        Property property = PropertyFactoryUtil.forName((String)"name");
        dynamicQuery.add(property.eq((Object)portletItemName));
        dynamicQuery.setLimit(0, 1);
        List portletItems = this.portletItemLocalService.dynamicQuery(dynamicQuery);
        if (portletItems.isEmpty()) {
            throw new PortalException("No portlet items associated with portlet item name " + portletItemName);
        }
        PortletItem portletItem = (PortletItem)portletItems.get(0);
        PortletPreferences portletPreferences = this.portletPreferencesLocalService.getPreferences(portletItem.getCompanyId(), portletItem.getPortletItemId(), 5, 0L, portletItem.getPortletId());
        String selectionStyle = GetterUtil.getString((String)portletPreferences.getValue("selectionStyle", null), (String)"dynamic");
        if (selectionStyle.equals("dynamic")) {
            List layouts;
            if (max > 500) {
                max = 500;
            }
            if (!(layouts = this.layoutLocalService.getLayouts(companyId)).isEmpty()) {
                Layout layout = (Layout)layouts.get(0);
                List<AssetEntry> assetEntries = AssetPublisherUtil.getAssetEntries((PortletPreferences)portletPreferences, (Layout)layout, (long)groupId, (int)max, (boolean)false);
                assetEntries = this.filterAssetEntries(assetEntries);
                return this.toJSONArray(assetEntries, locale);
            }
            return JSONFactoryUtil.createJSONArray();
        }
        try {
            PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)this.getUser());
            List<AssetEntry> assetEntries = AssetPublisherUtil.getAssetEntries(null, (PortletPreferences)portletPreferences, (PermissionChecker)permissionChecker, (long[])new long[]{groupId}, (boolean)false, (boolean)false, (boolean)false);
            assetEntries = this.filterAssetEntries(assetEntries);
            return this.toJSONArray(assetEntries, locale);
        }
        catch (PortalException | SystemException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PortalException((Throwable)e);
        }
    }

    public JSONObject getAssetEntry(long entryId, Locale locale) throws PortalException {
        AssetEntry entry = this.assetEntryLocalService.getEntry(entryId);
        AssetEntryPermission.check((PermissionChecker)this.getPermissionChecker(), (AssetEntry)entry, (String)"VIEW");
        return this.toJSONObject(entry, locale);
    }

    public JSONObject getAssetEntry(String className, long classPK, Locale locale) throws PortalException {
        AssetEntryPermission.check((PermissionChecker)this.getPermissionChecker(), (String)className, (long)classPK, (String)"VIEW");
        return this.toJSONObject(this.assetEntryLocalService.getEntry(className, classPK), locale);
    }

    protected List<AssetEntry> filterAssetEntries(List<AssetEntry> assetEntries) throws PortalException {
        ArrayList<AssetEntry> filteredAssetEntries = new ArrayList<AssetEntry>(assetEntries.size());
        for (AssetEntry assetEntry : assetEntries) {
            if (!AssetEntryPermission.contains((PermissionChecker)this.getPermissionChecker(), (AssetEntry)assetEntry, (String)"VIEW")) continue;
            filteredAssetEntries.add(assetEntry);
        }
        return filteredAssetEntries;
    }

    protected JSONObject getAssetObjectJSONObject(AssetEntry assetEntry, Locale locale) throws PortalException {
        String className = assetEntry.getClassName();
        if (className.equals(BlogsEntry.class.getName())) {
            return this.getBlogsEntryJSONObject(assetEntry);
        }
        if (className.equals(DLFileEntry.class.getName())) {
            return this.getFileEntryJSONObject(assetEntry);
        }
        if (className.equals(DDLRecord.class.getName())) {
            return this.screensDDLRecordService.getDDLRecord(assetEntry.getClassPK(), locale);
        }
        if (className.equals(JournalArticle.class.getName())) {
            return this.getJournalArticleJSONObject(assetEntry);
        }
        if (className.equals(User.class.getName())) {
            return this.getUserJSONObject(assetEntry);
        }
        return JSONFactoryUtil.createJSONObject();
    }

    protected JSONObject getBlogsEntryJSONObject(AssetEntry assetEntry) throws PortalException {
        BlogsEntry blogsEntry = this._blogsEntryService.getEntry(assetEntry.getClassPK());
        JSONObject blogsEntryJSONObject = JSONFactoryUtil.createJSONObject();
        blogsEntryJSONObject.put("blogsEntry", JSONFactoryUtil.createJSONObject((String)JSONFactoryUtil.looseSerialize((Object)blogsEntry)));
        return blogsEntryJSONObject;
    }

    protected JSONObject getFileEntryJSONObject(AssetEntry assetEntry) throws PortalException {
        FileEntry fileEntry = this.dlAppService.getFileEntry(assetEntry.getClassPK());
        JSONObject fileEntryJSONObject = JSONFactoryUtil.createJSONObject();
        fileEntryJSONObject.put("fileEntry", JSONFactoryUtil.createJSONObject((String)JSONFactoryUtil.looseSerialize((Object)fileEntry)));
        fileEntryJSONObject.put("url", this.getFileEntryPreviewURL(fileEntry));
        return fileEntryJSONObject;
    }

    protected String getFileEntryPreviewURL(FileEntry fileEntry) {
        StringBundler sb = new StringBundler(9);
        sb.append(PortalUtil.getPathContext());
        sb.append("/documents/");
        sb.append(fileEntry.getRepositoryId());
        sb.append("/");
        sb.append(fileEntry.getFolderId());
        sb.append("/");
        sb.append(URLCodec.encodeURL((String)HtmlUtil.unescape((String)fileEntry.getTitle())));
        sb.append("/");
        sb.append(fileEntry.getUuid());
        return sb.toString();
    }

    protected JSONObject getJournalArticleJSONObject(AssetEntry assetEntry) throws PortalException {
        JournalArticle journalArticle = null;
        JournalArticlePermission.check((PermissionChecker)this.getPermissionChecker(), (long)assetEntry.getClassPK(), (String)"VIEW");
        try {
            journalArticle = this.journalArticleLocalService.getArticle(assetEntry.getClassPK());
        }
        catch (Exception nsae) {
            JournalArticleResource journalArticleResource = this.journalArticleResourceLocalService.getArticleResource(assetEntry.getClassPK());
            journalArticle = this.journalArticleLocalService.getLatestArticle(journalArticleResource.getGroupId(), journalArticleResource.getArticleId());
        }
        JSONObject journalArticleJSONObject = JSONFactoryUtil.createJSONObject();
        journalArticleJSONObject.put("DDMStructure", JSONFactoryUtil.createJSONObject((String)JSONFactoryUtil.looseSerialize((Object)journalArticle.getDDMStructure())));
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)JSONFactoryUtil.looseSerialize((Object)journalArticle));
        journalArticleJSONObject.put("modelAttributes", jsonObject);
        journalArticleJSONObject.put("modelValues", jsonObject.getString("content"));
        jsonObject.remove("content");
        return journalArticleJSONObject;
    }

    protected JSONObject getUserJSONObject(AssetEntry assetEntry) throws PortalException {
        User user = this.userService.getUserById(assetEntry.getClassPK());
        JSONObject userJSONObject = JSONFactoryUtil.createJSONObject();
        userJSONObject.put("user", JSONFactoryUtil.createJSONObject((String)JSONFactoryUtil.looseSerialize((Object)user)));
        return userJSONObject;
    }

    protected JSONArray toJSONArray(List<AssetEntry> assetEntries, Locale locale) throws PortalException {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (AssetEntry assetEntry : assetEntries) {
            JSONObject jsonObject = this.toJSONObject(assetEntry, locale);
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }

    protected JSONObject toJSONObject(AssetEntry assetEntry, Locale locale) throws PortalException {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)JSONFactoryUtil.looseSerialize((Object)assetEntry));
        jsonObject.put("className", assetEntry.getClassName());
        jsonObject.put("description", assetEntry.getDescription(locale));
        jsonObject.put("locale", String.valueOf(locale));
        jsonObject.put("object", this.getAssetObjectJSONObject(assetEntry, locale));
        jsonObject.put("summary", assetEntry.getSummary(locale));
        jsonObject.put("title", assetEntry.getTitle(locale));
        return jsonObject;
    }
}

