/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.screens.service.impl;

import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.service.permission.DDLRecordPermission;
import com.liferay.dynamic.data.lists.service.permission.DDLRecordSetPermission;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.screens.service.base.ScreensDDLRecordServiceBaseImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class ScreensDDLRecordServiceImpl
extends ScreensDDLRecordServiceBaseImpl {
    public JSONObject getDDLRecord(long ddlRecordId, Locale locale) throws PortalException {
        DDLRecord ddlRecord = this.ddlRecordLocalService.getRecord(ddlRecordId);
        DDLRecordPermission.check((PermissionChecker)this.getPermissionChecker(), (DDLRecord)ddlRecord, (String)"VIEW");
        DDMFormValues ddmFormValues = ddlRecord.getDDMFormValues();
        Set availableLocales = ddmFormValues.getAvailableLocales();
        if (locale == null || !availableLocales.contains(locale)) {
            locale = ddmFormValues.getDefaultLocale();
        }
        return this.getDDLRecordJSONObject(ddlRecord, locale);
    }

    public JSONArray getDDLRecords(long ddlRecordSetId, Locale locale, int start, int end, OrderByComparator<DDLRecord> obc) throws PortalException {
        DDLRecordSetPermission.check((PermissionChecker)this.getPermissionChecker(), (long)ddlRecordSetId, (String)"VIEW");
        List ddlRecords = this.ddlRecordLocalService.getRecords(ddlRecordSetId, start, end, obc);
        return this.getDDLRecordsJSONArray(ddlRecords, locale);
    }

    public JSONArray getDDLRecords(long ddlRecordSetId, long userId, Locale locale, int start, int end, OrderByComparator<DDLRecord> obc) throws PortalException {
        DDLRecordSetPermission.check((PermissionChecker)this.getPermissionChecker(), (long)ddlRecordSetId, (String)"VIEW");
        List ddlRecords = this.ddlRecordLocalService.getRecords(ddlRecordSetId, userId, start, end, obc);
        return this.getDDLRecordsJSONArray(ddlRecords, locale);
    }

    public int getDDLRecordsCount(long ddlRecordSetId) throws PortalException {
        DDLRecordSetPermission.check((PermissionChecker)this.getPermissionChecker(), (long)ddlRecordSetId, (String)"VIEW");
        return this.ddlRecordLocalService.getRecordsCount(ddlRecordSetId);
    }

    public int getDDLRecordsCount(long ddlRecordSetId, long userId) throws PortalException {
        DDLRecordSetPermission.check((PermissionChecker)this.getPermissionChecker(), (long)ddlRecordSetId, (String)"VIEW");
        return this.ddlRecordLocalService.getRecordsCount(ddlRecordSetId, userId);
    }

    protected JSONObject getDDLRecordJSONObject(DDLRecord ddlRecord, Locale locale) throws PortalException {
        JSONObject ddlRecordJSONObject = JSONFactoryUtil.createJSONObject();
        ddlRecordJSONObject.put("modelAttributes", JSONFactoryUtil.createJSONObject((String)JSONFactoryUtil.looseSerialize((Object)ddlRecord.getModelAttributes())));
        HashMap<String, Object> ddlRecordMap = new HashMap<String, Object>();
        DDMFormValues ddmFormValues = ddlRecord.getDDMFormValues();
        Set availableLocales = ddmFormValues.getAvailableLocales();
        if (locale == null || !availableLocales.contains(locale)) {
            locale = ddmFormValues.getDefaultLocale();
        }
        block0: for (DDMFormFieldValue ddmFormFieldValue : ddmFormValues.getDDMFormFieldValues()) {
            Object fieldValue = this.getFieldValue(ddmFormFieldValue, locale);
            if (fieldValue != null) {
                ddlRecordMap.put(ddmFormFieldValue.getName(), fieldValue);
                continue;
            }
            for (Locale availableLocale : availableLocales) {
                fieldValue = this.getFieldValue(ddmFormFieldValue, availableLocale);
                if (fieldValue == null) continue;
                ddlRecordMap.put(ddmFormFieldValue.getName(), fieldValue);
                continue block0;
            }
        }
        ddlRecordJSONObject.put("modelValues", JSONFactoryUtil.createJSONObject((String)JSONFactoryUtil.looseSerialize(ddlRecordMap)));
        return ddlRecordJSONObject;
    }

    protected JSONArray getDDLRecordsJSONArray(List<DDLRecord> ddlRecords, Locale locale) throws PortalException {
        JSONArray ddlRecordsJSONArray = JSONFactoryUtil.createJSONArray();
        for (DDLRecord ddlRecord : ddlRecords) {
            JSONObject ddlRecordJSONObject = this.getDDLRecordJSONObject(ddlRecord, locale);
            ddlRecordsJSONArray.put(ddlRecordJSONObject);
        }
        return ddlRecordsJSONArray;
    }

    protected Object getFieldValue(DDMFormFieldValue ddmFormFieldValue, Locale locale) throws PortalException {
        Value value = ddmFormFieldValue.getValue();
        String fieldValueString = value.getString(locale);
        if (fieldValueString == null) {
            return null;
        }
        if (fieldValueString.isEmpty()) {
            return null;
        }
        String dataType = ddmFormFieldValue.getType();
        if (dataType.equals("boolean")) {
            return Boolean.valueOf(fieldValueString);
        }
        if (dataType.equals("date")) {
            return fieldValueString;
        }
        if (dataType.equals("document-library")) {
            return JSONFactoryUtil.looseSerialize((Object)JSONFactoryUtil.looseDeserialize((String)fieldValueString));
        }
        if (dataType.equals("float") || dataType.equals("number")) {
            if (Validator.isNull((String)fieldValueString)) {
                return null;
            }
            return Float.valueOf(fieldValueString);
        }
        if (dataType.equals("integer")) {
            if (Validator.isNull((String)fieldValueString)) {
                return null;
            }
            return Integer.valueOf(fieldValueString);
        }
        if (dataType.equals("long")) {
            if (Validator.isNull((String)fieldValueString)) {
                return null;
            }
            return Long.valueOf(fieldValueString);
        }
        if (dataType.equals("short")) {
            if (Validator.isNull((String)fieldValueString)) {
                return null;
            }
            return Short.valueOf(fieldValueString);
        }
        return fieldValueString;
    }
}

