/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.asah.rest.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.segments.asah.rest.dto.v1_0.ExperimentVariant;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(value="ExperimentRun")
@JsonFilter(value="Liferay.Vulcan")
@Schema(requiredProperties={"confidenceLevel", "experimentVariants"})
@XmlRootElement(name="ExperimentRun")
public class ExperimentRun {
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotNull
    protected Double confidenceLevel;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotNull
    protected ExperimentVariant[] experimentVariants;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected String status;
    @Schema(defaultValue="com.liferay.segments.asah.rest.dto.v1_0.ExperimentRun", name="x-class-name")
    public String xClassName;

    @DecimalMax(value="99")
    @DecimalMin(value="80")
    @Schema
    public @DecimalMax(value="99") @DecimalMin(value="80") Double getConfidenceLevel() {
        return this.confidenceLevel;
    }

    public void setConfidenceLevel(Double confidenceLevel) {
        this.confidenceLevel = confidenceLevel;
    }

    @JsonIgnore
    public void setConfidenceLevel(UnsafeSupplier<Double, Exception> confidenceLevelUnsafeSupplier) {
        try {
            this.confidenceLevel = (Double)confidenceLevelUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    @Valid
    public ExperimentVariant[] getExperimentVariants() {
        return this.experimentVariants;
    }

    public void setExperimentVariants(ExperimentVariant[] experimentVariants) {
        this.experimentVariants = experimentVariants;
    }

    @JsonIgnore
    public void setExperimentVariants(UnsafeSupplier<ExperimentVariant[], Exception> experimentVariantsUnsafeSupplier) {
        try {
            this.experimentVariants = (ExperimentVariant[])experimentVariantsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @JsonIgnore
    public void setStatus(UnsafeSupplier<String, Exception> statusUnsafeSupplier) {
        try {
            this.status = (String)statusUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ExperimentRun)) {
            return false;
        }
        ExperimentRun experimentRun = (ExperimentRun)object;
        return Objects.equals(this.toString(), experimentRun.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        StringBundler sb = new StringBundler();
        sb.append("{");
        if (this.confidenceLevel != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"confidenceLevel\": ");
            sb.append((Object)this.confidenceLevel);
        }
        if (this.experimentVariants != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"experimentVariants\": ");
            sb.append("[");
            for (int i = 0; i < this.experimentVariants.length; ++i) {
                sb.append(String.valueOf(this.experimentVariants[i]));
                if (i + 1 >= this.experimentVariants.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.status != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"status\": ");
            sb.append("\"");
            sb.append(ExperimentRun._escape(this.status));
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        String string = String.valueOf(object);
        return string.replaceAll("\"", "\\\\\"");
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(entry.getKey());
            sb.append("\":");
            sb.append("\"");
            sb.append(entry.getValue());
            sb.append("\"");
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }
}

