Liferay.Loader.define('segments-experiment-web$lodash-es@4.17.15/_Hash', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import hashClear from './_hashClear.js';
    import hashDelete from './_hashDelete.js';
    import hashGet from './_hashGet.js';
    import hashHas from './_hashHas.js';
    import hashSet from './_hashSet.js';

    /**
     * Creates a hash object.
     *
     * @private
     * @constructor
     * @param {Array} [entries] The key-value pairs to cache.
     */
    function Hash(entries) {
      var index = -1,
          length = entries == null ? 0 : entries.length;

      this.clear();
      while (++index < length) {
        var entry = entries[index];
        this.set(entry[0], entry[1]);
      }
    }

    // Add methods to `Hash`.
    Hash.prototype.clear = hashClear;
    Hash.prototype['delete'] = hashDelete;
    Hash.prototype.get = hashGet;
    Hash.prototype.has = hashHas;
    Hash.prototype.set = hashSet;

    export default Hash;
  }
});
//# sourceMappingURL=_Hash.js.map