/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.simulation.web.internal.simulator;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactory;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.segments.simulator.SegmentsEntrySimulator;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.portal.kernel.model.User"}, service={SegmentsEntrySimulator.class})
public class PortalPreferencesUserSegmentsEntrySimulator
implements SegmentsEntrySimulator {
    private static final Log _log = LogFactoryUtil.getLog(PortalPreferencesUserSegmentsEntrySimulator.class);
    @Reference
    private PortletPreferencesFactory _portletPreferencesFactory;

    public void deactivateSimulation(long userId) {
        while (true) {
            try {
                PortalPreferences portalPreferences = this._portletPreferencesFactory.getPortalPreferences(userId, true);
                portalPreferences.setValues("com_liferay_segments_simulation_web_internal_portlet_SegmentsSimulationPortlet", "simulatedSegmentsEntryIds", null);
                portalPreferences.setValue("com_liferay_segments_simulation_web_internal_portlet_SegmentsSimulationPortlet", "simulationActive", Boolean.FALSE.toString());
            }
            catch (ConcurrentModificationException cme) {
                continue;
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
            break;
        }
    }

    public long[] getSimulatedSegmentsEntryIds(long userId) {
        PortalPreferences portalPreferences = this._portletPreferencesFactory.getPortalPreferences(userId, true);
        String[] simulatedSegmentsEntryIds = portalPreferences.getValues("com_liferay_segments_simulation_web_internal_portlet_SegmentsSimulationPortlet", "simulatedSegmentsEntryIds");
        if (simulatedSegmentsEntryIds == null) {
            return new long[0];
        }
        Stream<String> stream = Arrays.stream(simulatedSegmentsEntryIds);
        return stream.mapToLong(Long::valueOf).toArray();
    }

    public boolean isSimulationActive(long userId) {
        PortalPreferences portalPreferences = this._portletPreferencesFactory.getPortalPreferences(userId, true);
        return GetterUtil.getBoolean((String)portalPreferences.getValue("com_liferay_segments_simulation_web_internal_portlet_SegmentsSimulationPortlet", "simulationActive"));
    }

    public void setSimulatedSegmentsEntryIds(long userId, long[] segmentsEntryIds) {
        while (true) {
            try {
                PortalPreferences portalPreferences = this._portletPreferencesFactory.getPortalPreferences(userId, true);
                portalPreferences.setValues("com_liferay_segments_simulation_web_internal_portlet_SegmentsSimulationPortlet", "simulatedSegmentsEntryIds", ArrayUtil.toStringArray((long[])segmentsEntryIds));
                portalPreferences.setValue("com_liferay_segments_simulation_web_internal_portlet_SegmentsSimulationPortlet", "simulationActive", Boolean.TRUE.toString());
            }
            catch (ConcurrentModificationException cme) {
                continue;
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
            break;
        }
    }
}

