/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharing.security.permission;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SharingEntryAction {
    ADD_DISCUSSION("ADD_DISCUSSION", 4L),
    UPDATE("UPDATE", 2L),
    VIEW("VIEW", 1L);

    private final String _actionId;
    private final long _bitwiseValue;

    public static Collection<SharingEntryAction> getSharingEntryActions(long bitwiseValue) {
        return Stream.of(SharingEntryAction.values()).filter(sharingEntryAction -> (sharingEntryAction.getBitwiseValue() & bitwiseValue) != 0L).collect(Collectors.toList());
    }

    public static boolean isSupportedActionId(String actionId) {
        for (SharingEntryAction sharingEntryAction : SharingEntryAction.values()) {
            if (!Objects.equals(sharingEntryAction.getActionId(), actionId)) continue;
            return true;
        }
        return false;
    }

    public static SharingEntryAction parseFromActionId(String actionId) {
        if (Objects.equals(ADD_DISCUSSION.getActionId(), actionId)) {
            return ADD_DISCUSSION;
        }
        if (Objects.equals(UPDATE.getActionId(), actionId)) {
            return UPDATE;
        }
        if (Objects.equals(VIEW.getActionId(), actionId)) {
            return VIEW;
        }
        throw new IllegalArgumentException("Invalid action ID " + actionId);
    }

    public static SharingEntryAction parseFromBitwiseValue(long bitwiseValue) {
        if (Objects.equals(ADD_DISCUSSION.getBitwiseValue(), bitwiseValue)) {
            return ADD_DISCUSSION;
        }
        if (Objects.equals(UPDATE.getBitwiseValue(), bitwiseValue)) {
            return UPDATE;
        }
        if (Objects.equals(VIEW.getBitwiseValue(), bitwiseValue)) {
            return VIEW;
        }
        throw new IllegalArgumentException("Invalid bitwise value " + bitwiseValue);
    }

    public String getActionId() {
        return this._actionId;
    }

    public long getBitwiseValue() {
        return this._bitwiseValue;
    }

    private SharingEntryAction(String actionId, long bitwiseValue) {
        this._actionId = actionId;
        this._bitwiseValue = bitwiseValue;
    }
}

