/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharing.internal.security.permission.contributor;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.security.permission.contributor.PermissionSQLContributor;
import com.liferay.sharing.configuration.SharingConfiguration;
import com.liferay.sharing.configuration.SharingConfigurationFactory;

public class SharingPermissionSQLContributor
implements PermissionSQLContributor {
    private final ClassNameLocalService _classNameLocalService;
    private final GroupLocalService _groupLocalService;
    private final SharingConfigurationFactory _sharingConfigurationFactory;

    public SharingPermissionSQLContributor(ClassNameLocalService classNameLocalService, GroupLocalService groupLocalService, SharingConfigurationFactory sharingConfigurationFactory) {
        this._classNameLocalService = classNameLocalService;
        this._groupLocalService = groupLocalService;
        this._sharingConfigurationFactory = sharingConfigurationFactory;
    }

    public String getPermissionSQL(String className, String classPKField, String userIdField, String groupIdField, long[] groupIds) {
        SharingConfiguration sharingConfiguration = this._sharingConfigurationFactory.getSystemSharingConfiguration();
        if (!sharingConfiguration.isEnabled()) {
            return "";
        }
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        StringBundler sb = new StringBundler(7);
        sb.append(classPKField);
        sb.append(" IN (SELECT SharingEntry.classPK FROM SharingEntry WHERE ");
        this._addDisabledGroupsSQL(sb, groupIds);
        sb.append("(SharingEntry.toUserId = ");
        sb.append(permissionChecker.getUserId());
        sb.append(") AND (SharingEntry.classNameId = ");
        sb.append(this._classNameLocalService.getClassNameId(className));
        sb.append("))");
        return sb.toString();
    }

    private void _addDisabledGroupsSQL(StringBundler sb, long[] groupIds) {
        if (groupIds == null || groupIds.length == 0) {
            return;
        }
        int groupCount = 0;
        for (long groupId : groupIds) {
            SharingConfiguration sharingConfiguration;
            if (groupId == 0L || (sharingConfiguration = this._getSharingConfiguration(groupId)).isEnabled()) continue;
            if (groupCount == 0) {
                sb.append("(SharingEntry.groupId NOT IN (");
            } else {
                sb.append(", ");
            }
            sb.append(groupId);
            ++groupCount;
        }
        if (groupCount > 0) {
            sb.append(")) AND");
        }
    }

    private SharingConfiguration _getSharingConfiguration(long groupId) {
        try {
            return this._sharingConfigurationFactory.getGroupSharingConfiguration(this._groupLocalService.getGroup(groupId));
        }
        catch (PortalException portalException) {
            return (SharingConfiguration)ReflectionUtil.throwException((Throwable)portalException);
        }
    }
}

