/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharing.service.persistence.impl;

import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.sharing.model.SharingEntry;
import com.liferay.sharing.model.impl.SharingEntryImpl;
import com.liferay.sharing.service.persistence.SharingEntryFinder;
import com.liferay.sharing.service.persistence.impl.SharingEntryFinderBaseImpl;
import java.util.Iterator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SharingEntryFinder.class})
public class SharingEntryFinderImpl
extends SharingEntryFinderBaseImpl
implements SharingEntryFinder {
    public static final String COUNT_BY_USER_ID = SharingEntryFinder.class.getName() + ".countByUserId";
    public static final String FIND_BY_USER_ID = SharingEntryFinder.class.getName() + ".findByUserId";
    @Reference
    private CustomSQL _customSQL;

    public int countByUserId(long userId, long classNameId) {
        Session session = null;
        try {
            Long count;
            Iterator itr;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_BY_USER_ID);
            sql = this._replaceClassNameIdWhere(sql, classNameId);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(userId);
            if (classNameId > 0L) {
                qPos.add(classNameId);
            }
            if ((itr = q.iterate()).hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<SharingEntry> findByUserId(long userId, long classNameId, int begin, int end, OrderByComparator<SharingEntry> orderByComparator) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_USER_ID);
            if (orderByComparator != null) {
                sql = this._customSQL.replaceOrderBy(sql, orderByComparator);
            }
            sql = this._replaceClassNameIdWhere(sql, classNameId);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("SharingEntry", SharingEntryImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(userId);
            if (classNameId > 0L) {
                qPos.add(classNameId);
            }
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)begin, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    private String _replaceClassNameIdWhere(String sql, long classNameId) {
        sql = classNameId > 0L ? StringUtil.replace((String)sql, (String)"[$CLASS_NAME_ID_WHERE$]", (String)"AND SharingEntry.classNameId = ?") : StringUtil.removeSubstring((String)sql, (String)"[$CLASS_NAME_ID_WHERE$]");
        return sql;
    }
}

