/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.item.selector.web.internal.servlet.taglib.clay;

import com.liferay.frontend.taglib.clay.servlet.taglib.soy.VerticalCard;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.service.GroupServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.site.util.GroupURLProvider;
import java.util.Collections;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;

public class SiteVerticalCard
implements VerticalCard {
    private static final Log _log = LogFactoryUtil.getLog(SiteVerticalCard.class);
    private final Group _group;
    private final GroupURLProvider _groupURLProvider;
    private final HttpServletRequest _httpServletRequest;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final ThemeDisplay _themeDisplay;

    public SiteVerticalCard(Group group, LiferayPortletRequest liferayPortletRequest) {
        this._group = group;
        this._liferayPortletRequest = liferayPortletRequest;
        this._groupURLProvider = (GroupURLProvider)liferayPortletRequest.getAttribute("GROUP_URL_PROVIDER");
        this._httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)liferayPortletRequest);
        this._themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public String getElementClasses() {
        return "card-interactive card-interactive-secondary";
    }

    public String getHref() {
        return this._groupURLProvider.getGroupURL(this._group, (PortletRequest)this._liferayPortletRequest);
    }

    public String getIcon() {
        return "sites";
    }

    public String getImageSrc() {
        return this._group.getLogoURL(this._themeDisplay, false);
    }

    public String getSubtitle() {
        if (this._group.isCompany()) {
            return "-";
        }
        List childSites = null;
        try {
            childSites = GroupServiceUtil.getGroups((long)this._group.getCompanyId(), (long)this._group.getGroupId(), (boolean)true);
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            childSites = Collections.emptyList();
        }
        return LanguageUtil.format((HttpServletRequest)this._httpServletRequest, (String)"x-child-sites", (Object)childSites.size());
    }

    public String getTitle() {
        try {
            return HtmlUtil.escape((String)this._group.getDescriptiveName(this._themeDisplay.getLocale()));
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)e, (Throwable)e);
            }
            return HtmlUtil.escape((String)this._group.getName(this._themeDisplay.getLocale()));
        }
    }

    public boolean isSelectable() {
        return false;
    }
}

