/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.internal.initializer;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.site.initializer.SiteInitializer;
import com.liferay.site.initializer.SiteInitializerRegistry;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(immediate=true, service={SiteInitializerRegistry.class})
public class SiteInitializerRegistryImpl
implements SiteInitializerRegistry {
    private static final Log _log = LogFactoryUtil.getLog(SiteInitializerRegistryImpl.class);
    private ServiceTrackerMap<String, SiteInitializer> _serviceTrackerMap;

    public SiteInitializer getSiteInitializer(String key) {
        if (Validator.isNull((String)key)) {
            return null;
        }
        SiteInitializer siteInitializer = (SiteInitializer)this._serviceTrackerMap.getService((Object)key);
        if (siteInitializer == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No site initializer registered with key " + key));
            }
            return null;
        }
        return siteInitializer;
    }

    public List<SiteInitializer> getSiteInitializers(long companyId) {
        return this.getSiteInitializers(companyId, false);
    }

    public List<SiteInitializer> getSiteInitializers(long companyId, boolean activeOnly) {
        if (!activeOnly) {
            return new ArrayList<SiteInitializer>(this._serviceTrackerMap.values());
        }
        ArrayList<SiteInitializer> siteInitializers = new ArrayList<SiteInitializer>();
        for (SiteInitializer siteInitializer : this._serviceTrackerMap.values()) {
            if (!siteInitializer.isActive(companyId)) continue;
            siteInitializers.add(siteInitializer);
        }
        return siteInitializers;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, SiteInitializer.class, (String)"site.initializer.key");
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

