/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.site.model.SiteFriendlyURL;
import com.liferay.site.service.base.SiteFriendlyURLLocalServiceBaseImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.site.model.SiteFriendlyURL"}, service={AopService.class})
public class SiteFriendlyURLLocalServiceImpl
extends SiteFriendlyURLLocalServiceBaseImpl {
    public SiteFriendlyURL addSiteFriendlyURL(long userId, long companyId, long groupId, String friendlyURL, String languageId, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        long siteFriendlyURLId = this.counterLocalService.increment();
        SiteFriendlyURL siteFriendlyURL = this.siteFriendlyURLPersistence.create(siteFriendlyURLId);
        if (serviceContext != null) {
            siteFriendlyURL.setUuid(serviceContext.getUuid());
        }
        siteFriendlyURL.setGroupId(groupId);
        siteFriendlyURL.setCompanyId(companyId);
        siteFriendlyURL.setUserId(user.getUserId());
        siteFriendlyURL.setUserName(user.getFullName());
        siteFriendlyURL.setFriendlyURL(friendlyURL);
        siteFriendlyURL.setLanguageId(languageId);
        return (SiteFriendlyURL)this.siteFriendlyURLPersistence.update((BaseModel)siteFriendlyURL);
    }

    public List<SiteFriendlyURL> addSiteFriendlyURLs(long userId, long companyId, long groupId, Map<Locale, String> friendlyURLMap, ServiceContext serviceContext) throws PortalException {
        ArrayList<SiteFriendlyURL> siteFriendlyURLs = new ArrayList<SiteFriendlyURL>();
        for (Locale locale : LanguageUtil.getAvailableLocales((long)groupId)) {
            String friendlyURL = friendlyURLMap.get(locale);
            if (Validator.isNull((String)friendlyURL)) continue;
            SiteFriendlyURL siteFriendlyURL = this.addSiteFriendlyURL(userId, companyId, groupId, friendlyURL, LocaleUtil.toLanguageId((Locale)locale), serviceContext);
            siteFriendlyURLs.add(siteFriendlyURL);
        }
        return siteFriendlyURLs;
    }

    public SiteFriendlyURL deleteSiteFriendlyURL(long companyId, long groupId, String languageId) throws PortalException {
        return this.siteFriendlyURLPersistence.removeByC_G_L(companyId, groupId, languageId);
    }

    @Override
    public SiteFriendlyURL deleteSiteFriendlyURL(SiteFriendlyURL siteFriendlyURL) {
        return (SiteFriendlyURL)this.siteFriendlyURLPersistence.remove((BaseModel)siteFriendlyURL);
    }

    public void deleteSiteFriendlyURLs(long companyId, long groupId) {
        this.siteFriendlyURLPersistence.removeByC_G(companyId, groupId);
    }

    public SiteFriendlyURL fetchSiteFriendlyURL(long companyId, long groupId, String languageId) {
        return this.siteFriendlyURLPersistence.fetchByC_G_L(companyId, groupId, languageId);
    }

    public SiteFriendlyURL fetchSiteFriendlyURLByFriendlyURL(long companyId, String friendlyURL) {
        return this.siteFriendlyURLPersistence.fetchByC_F(companyId, friendlyURL);
    }

    public List<SiteFriendlyURL> getSiteFriendlyURLs(long companyId, long groupId) {
        return this.siteFriendlyURLPersistence.findByC_G(companyId, groupId);
    }

    public SiteFriendlyURL updateSiteFriendlyURL(long userId, long companyId, long groupId, String friendlyURL, String languageId, ServiceContext serviceContext) throws PortalException {
        SiteFriendlyURL siteFriendlyURL = this.siteFriendlyURLPersistence.fetchByC_G_L(companyId, groupId, languageId);
        if (siteFriendlyURL == null) {
            siteFriendlyURL = this.addSiteFriendlyURL(userId, companyId, groupId, friendlyURL, languageId, serviceContext);
        }
        siteFriendlyURL.setFriendlyURL(friendlyURL);
        return (SiteFriendlyURL)this.siteFriendlyURLPersistence.update((BaseModel)siteFriendlyURL);
    }

    public List<SiteFriendlyURL> updateSiteFriendlyURLs(long userId, long companyId, long groupId, Map<Locale, String> friendlyURLMap, ServiceContext serviceContext) throws PortalException {
        ArrayList<SiteFriendlyURL> siteFriendlyURLs = new ArrayList<SiteFriendlyURL>();
        for (Locale locale : LanguageUtil.getAvailableLocales((long)groupId)) {
            String friendlyURL = friendlyURLMap.get(locale);
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            SiteFriendlyURL siteFriendlyURL = this.siteFriendlyURLPersistence.fetchByC_G_L(companyId, groupId, languageId);
            if (Validator.isNull((String)friendlyURL) && siteFriendlyURL != null) {
                this.deleteSiteFriendlyURL(companyId, groupId, languageId);
            }
            siteFriendlyURL = this.updateSiteFriendlyURL(userId, companyId, groupId, friendlyURL, languageId, serviceContext);
            siteFriendlyURLs.add(siteFriendlyURL);
        }
        return siteFriendlyURLs;
    }
}

