/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.JSPSourceUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class BaseJSPTermsCheck
extends BaseFileCheck {
    private List<String> _allFileNames;
    private Map<String, String> _contentsMap;

    @Override
    public void setAllFileNames(List<String> allFileNames) {
        this._allFileNames = allFileNames;
    }

    protected Map<String, String> getContentsMap() {
        return this._contentsMap;
    }

    protected boolean hasUnusedJSPTerm(String fileName, String regex, String type, Set<String> checkedForIncludesFileNames, Set<String> includeFileNames, Map<String, String> contentsMap) {
        return this.hasUnusedJSPTerm(fileName, null, regex, type, checkedForIncludesFileNames, includeFileNames, contentsMap);
    }

    protected boolean hasUnusedJSPTerm(String fileName, String content, String regex, String type, Set<String> checkedForIncludesFileNames, Set<String> includeFileNames, Map<String, String> contentsMap) {
        includeFileNames.add(fileName);
        HashSet<String> checkedForUnusedJSPTerm = new HashSet<String>();
        return !this._isJSPTermRequired(fileName, content, regex, type, checkedForUnusedJSPTerm, checkedForIncludesFileNames, includeFileNames, contentsMap);
    }

    protected synchronized void populateContentsMap(String fileName, String content) throws IOException {
        if (this._contentsMap != null) {
            return;
        }
        String[] excludes = new String[]{"**/null.jsp", "**/tools/**"};
        List<String> allJSPFileNames = SourceFormatterUtil.filterFileNames(this._allFileNames, excludes, new String[]{"**/*.jsp", "**/*.jspf", "**/*.tag"}, this.getSourceFormatterExcludes(), true);
        this._contentsMap = JSPSourceUtil.getContentsMap(allJSPFileNames);
        if (this._contentsMap.isEmpty()) {
            this._contentsMap.put(fileName, content);
        }
    }

    protected void put(String fileName, String content) {
        this._contentsMap.put(fileName, content);
    }

    private boolean _isJSPTermRequired(String fileName, String content, String regex, String type, Set<String> checkedForUnusedJSPTerm, Set<String> checkedForIncludesFileNames, Set<String> includeFileNames, Map<String, String> contentsMap) {
        String[] includeFileNamesArray;
        if (checkedForUnusedJSPTerm.contains(fileName)) {
            return false;
        }
        checkedForUnusedJSPTerm.add(fileName);
        if (content == null) {
            content = contentsMap.get(fileName);
        }
        if (Validator.isNull(content)) {
            return false;
        }
        int count = 0;
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            if (type.equals("taglib")) {
                ++count;
                continue;
            }
            int x = matcher.start() + 1;
            if (JSPSourceUtil.isJavaSource(content, x)) {
                if (ToolsUtil.isInsideQuotes(content, x)) continue;
                ++count;
                continue;
            }
            String line = StringUtil.trim(this.getLine(content, this.getLineNumber(content, matcher.start())));
            if (line.startsWith("function ")) continue;
            int y = content.lastIndexOf("<%", x) + 2;
            int z = content.lastIndexOf("%>", x);
            if (y == 1 || z > y || (z = content.indexOf("%>", x)) != -1 && this.getLineNumber(content, y) == this.getLineNumber(content, z) && ToolsUtil.isInsideQuotes(content.substring(y, z), x - y)) continue;
            ++count;
        }
        if (count > 1 || count == 1 && (!type.equals("variable") || checkedForUnusedJSPTerm.size() > 1)) {
            return true;
        }
        if (!checkedForIncludesFileNames.contains(fileName)) {
            includeFileNames.addAll(JSPSourceUtil.getJSPIncludeFileNames(fileName, includeFileNames, contentsMap, false));
            includeFileNames.addAll(JSPSourceUtil.getJSPReferenceFileNames(fileName, includeFileNames, contentsMap, ".*\\.(jsp|jspf|tag)"));
        }
        checkedForIncludesFileNames.add(fileName);
        for (String includeFileName : includeFileNamesArray = includeFileNames.toArray(new String[0])) {
            if (checkedForUnusedJSPTerm.contains(includeFileName) || !this._isJSPTermRequired(includeFileName, null, regex, type, checkedForUnusedJSPTerm, checkedForIncludesFileNames, includeFileNames, contentsMap)) continue;
            return true;
        }
        return false;
    }
}

