/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaTerm;
import java.io.IOException;
import java.util.List;

public class JavaClassNameCheck
extends BaseJavaTermCheck {
    private static final String _ENFORCE_IMPLEMENTED_CLASS_NAMES_KEY = "enforceImplementedClassNames";

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) throws IOException {
        if (javaTerm.getParentJavaClass() != null) {
            return javaTerm.getContent();
        }
        JavaClass javaClass = (JavaClass)javaTerm;
        if (javaClass.isAnonymous() || javaClass.hasAnnotation("Deprecated")) {
            return javaTerm.getContent();
        }
        List<String> implementedClassNames = javaClass.getImplementedClassNames();
        if (implementedClassNames.isEmpty()) {
            return javaTerm.getContent();
        }
        List<String> enforceImplementedClassNames = this.getAttributeValues(_ENFORCE_IMPLEMENTED_CLASS_NAMES_KEY, absolutePath);
        for (String implementedClassName : enforceImplementedClassNames) {
            String className;
            if (!implementedClassNames.contains(implementedClassName) || (className = javaClass.getName()).endsWith(implementedClassName)) continue;
            this.addMessage(fileName, StringBundler.concat("Name of class implementing '", implementedClassName, "' should end with '", implementedClassName, "'"));
        }
        return javaTerm.getContent();
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CLASS};
    }
}

