/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.maven;

import com.liferay.source.formatter.SourceFormatter;
import com.liferay.source.formatter.SourceFormatterArgs;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class SourceFormatterMojo
extends AbstractMojo {
    private final SourceFormatterArgs _sourceFormatterArgs = new SourceFormatterArgs();

    public void execute() throws MojoExecutionException {
        try {
            Map pluginContext = this.getPluginContext();
            SourceFormatter sourceFormatter = new SourceFormatter(this._sourceFormatterArgs);
            sourceFormatter.format();
            List<String> modifiedFileNames = sourceFormatter.getModifiedFileNames();
            pluginContext.put("source.formatter.modified.files", modifiedFileNames);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    public void setAutoFix(boolean autoFix) {
        this._sourceFormatterArgs.setAutoFix(autoFix);
    }

    public void setBaseDir(String baseDir) {
        this._sourceFormatterArgs.setBaseDirName(baseDir);
    }

    public void setCopyright(String copyright) {
        this._sourceFormatterArgs.setCopyrightFileName(copyright);
    }

    public void setFileNames(String[] fileNames) {
        this._sourceFormatterArgs.setFileNames(Arrays.asList(fileNames));
    }

    public void setFormatCurrentBranch(boolean formatCurrentBranch) {
        this._sourceFormatterArgs.setFormatCurrentBranch(formatCurrentBranch);
    }

    public void setFormatLatestAuthor(boolean formatLatestAuthor) {
        this._sourceFormatterArgs.setFormatLatestAuthor(formatLatestAuthor);
    }

    public void setFormatLocalChanges(boolean formatLocalChanges) {
        this._sourceFormatterArgs.setFormatLocalChanges(formatLocalChanges);
    }

    public void setPrintErrors(boolean printErrors) {
        this._sourceFormatterArgs.setPrintErrors(printErrors);
    }

    public void setThrowException(boolean throwException) {
        this._sourceFormatterArgs.setThrowException(throwException);
    }

    public void setUseProperties(boolean useProperties) {
        this._sourceFormatterArgs.setUseProperties(useProperties);
    }
}

