/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.BaseMapBuilder;
import com.liferay.portal.kernel.util.BaseMapWrapper;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ConcurrentHashMapBuilder<K, V>
extends BaseMapBuilder {
    public static <K, V> ConcurrentHashMapWrapper<K, V> put(Collection<? extends K> inputCollection, BaseMapBuilder.UnsafeFunction<K, V, Exception> unsafeFunction) {
        ConcurrentHashMapWrapper<Collection<? extends K>, BaseMapBuilder.UnsafeFunction<K, V, Exception>> concurrentHashMapWrapper = new ConcurrentHashMapWrapper<Collection<? extends K>, BaseMapBuilder.UnsafeFunction<K, V, Exception>>();
        return concurrentHashMapWrapper.put(inputCollection, unsafeFunction);
    }

    public static <K, V> ConcurrentHashMapWrapper<K, V> put(K key, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
        ConcurrentHashMapWrapper<K, BaseMapBuilder.UnsafeSupplier<V, Exception>> concurrentHashMapWrapper = new ConcurrentHashMapWrapper<K, BaseMapBuilder.UnsafeSupplier<V, Exception>>();
        return concurrentHashMapWrapper.put(key, valueUnsafeSupplier);
    }

    public static <K, V> ConcurrentHashMapWrapper<K, V> put(K key, V value) {
        ConcurrentHashMapWrapper<K, V> concurrentHashMapWrapper = new ConcurrentHashMapWrapper<K, V>();
        return concurrentHashMapWrapper.put(key, value);
    }

    public static <K, V> ConcurrentHashMapWrapper<K, V> put(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
        ConcurrentHashMapWrapper<K, BaseMapBuilder.UnsafeSupplier<V, Exception>> concurrentHashMapWrapper = new ConcurrentHashMapWrapper<K, BaseMapBuilder.UnsafeSupplier<V, Exception>>();
        return concurrentHashMapWrapper.put(keyUnsafeSupplier, valueUnsafeSupplier);
    }

    public static <K, V> ConcurrentHashMapWrapper<K, V> put(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, V value) {
        ConcurrentHashMapWrapper<K, V> concurrentHashMapWrapper = new ConcurrentHashMapWrapper<K, V>();
        return concurrentHashMapWrapper.put(keyUnsafeSupplier, value);
    }

    public static <K, V> ConcurrentHashMapWrapper<K, V> putAll(Map<? extends K, ? extends V> inputMap) {
        ConcurrentHashMapWrapper<? extends K, ? extends V> concurrentHashMapWrapper = new ConcurrentHashMapWrapper<K, V>();
        return concurrentHashMapWrapper.putAll(inputMap);
    }

    public static final class ConcurrentHashMapWrapper<K, V>
    extends BaseMapWrapper<K, V> {
        private final ConcurrentHashMap<K, V> _concurrentHashMap = new ConcurrentHashMap();

        public ConcurrentHashMap<K, V> build() {
            return this._concurrentHashMap;
        }

        public ConcurrentHashMapWrapper<K, V> put(Collection<? extends K> inputCollection, BaseMapBuilder.UnsafeFunction<K, V, Exception> unsafeFunction) {
            this.doPut(inputCollection, unsafeFunction);
            return this;
        }

        public ConcurrentHashMapWrapper<K, V> put(K key, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
            this.doPut(key, valueUnsafeSupplier);
            return this;
        }

        public ConcurrentHashMapWrapper<K, V> put(K key, V value) {
            this._concurrentHashMap.put(key, value);
            return this;
        }

        public ConcurrentHashMapWrapper<K, V> put(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
            this.doPut(keyUnsafeSupplier, valueUnsafeSupplier);
            return this;
        }

        public ConcurrentHashMapWrapper<K, V> put(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, V value) {
            this.doPut(keyUnsafeSupplier, value);
            return this;
        }

        public ConcurrentHashMapWrapper<K, V> putAll(Map<? extends K, ? extends V> inputMap) {
            this.doPutAll(inputMap);
            return this;
        }

        @Override
        protected ConcurrentHashMap<K, V> getMap() {
            return this._concurrentHashMap;
        }
    }
}

