/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class UnicodeProperties
extends HashMap<String, String> {
    private static final String _SAFE_NEWLINE_CHARACTER = "_SAFE_NEWLINE_CHARACTER_";
    private static final Log _log = LogFactoryUtil.getLog(UnicodeProperties.class);
    private final boolean _safe;

    public UnicodeProperties() {
        this._safe = false;
    }

    public UnicodeProperties(boolean safe) {
        this._safe = safe;
    }

    public void fastLoad(String props) {
        if (Validator.isNull(props)) {
            return;
        }
        int x = props.indexOf(10);
        int y = 0;
        while (x != -1) {
            this.put(props.substring(y, x));
            y = x;
            x = props.indexOf(10, y + 1);
        }
        this.put(props.substring(y));
    }

    public String getProperty(String key) {
        return (String)this.get(key);
    }

    public String getProperty(String key, String defaultValue) {
        String value = (String)this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public boolean isSafe() {
        return this._safe;
    }

    public void load(String props) throws IOException {
        if (Validator.isNull(props)) {
            return;
        }
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(props));){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                this.put(line);
            }
        }
    }

    public void put(String line) {
        if (this._isComment(line = line.trim())) {
            return;
        }
        int pos = line.indexOf(61);
        if (pos == -1) {
            _log.error("Invalid property on line " + line);
        } else {
            String value = StringUtil.trim(line.substring(pos + 1));
            if (this._safe) {
                value = this._decode(value);
            }
            this.setProperty(StringUtil.trim(line.substring(0, pos)), value);
        }
    }

    @Override
    public String put(String key, String value) {
        if (key == null) {
            return null;
        }
        if (value == null) {
            return (String)super.remove(key);
        }
        return super.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> map) {
        for (Map.Entry<? extends String, ? extends String> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public String remove(Object key) {
        if (key == null) {
            return null;
        }
        return (String)super.remove(key);
    }

    public String setProperty(String key, String value) {
        return this.put(key, value);
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(4 * this.size());
        TreeMap<String, String> treeMap = new TreeMap<String, String>(this);
        for (Map.Entry entry : treeMap.entrySet()) {
            String value = (String)entry.getValue();
            if (Validator.isNull(value)) continue;
            if (this._safe) {
                value = this._encode(value);
            }
            sb.append((String)entry.getKey());
            sb.append("=");
            sb.append(value);
            sb.append("\n");
        }
        return sb.toString();
    }

    private String _decode(String value) {
        return StringUtil.replace(value, _SAFE_NEWLINE_CHARACTER, "\n");
    }

    private String _encode(String value) {
        String encodedValue = StringUtil.replace(value, "\r\n", _SAFE_NEWLINE_CHARACTER);
        return StringUtil.replace(encodedValue, new char[]{'\n', '\r'}, new String[]{_SAFE_NEWLINE_CHARACTER, _SAFE_NEWLINE_CHARACTER});
    }

    private boolean _isComment(String line) {
        return line.isEmpty() || line.charAt(0) == '#';
    }
}

