/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.io.IOException;

public class YMLLongLinesCheck
extends BaseFileCheck {
    private static final String _MAX_LINE_LENGTH = "maxLineLength";

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        int maxLineLength = 0;
        try {
            maxLineLength = Integer.parseInt(this.getAttributeValue(_MAX_LINE_LENGTH, absolutePath));
        }
        catch (NumberFormatException numberFormatException) {
            return content;
        }
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            int lineNumber = 0;
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if (line.matches(" +-")) continue;
                ++lineNumber;
                if (this.getLineLength(line) <= maxLineLength) continue;
                this.addMessage(fileName, "> " + maxLineLength, lineNumber);
            }
        }
        return content;
    }
}

