/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks.configuration;

import com.liferay.source.formatter.util.CheckType;
import com.puppycrawl.tools.checkstyle.api.Filter;
import com.puppycrawl.tools.checkstyle.api.FilterSet;
import com.puppycrawl.tools.checkstyle.filters.SuppressFilterElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SourceFormatterSuppressions {
    private final FilterSet _checkstyleFilterSet = new FilterSet();
    private final Map<String, List<String>> _sourceChecksSuppressionsMap = new HashMap<String, List<String>>();

    public void addSuppression(CheckType checkType, String suppressionsFileLocation, String checkName, String fileNameRegex) {
        if (fileNameRegex == null) {
            fileNameRegex = ".*";
        }
        if (!suppressionsFileLocation.endsWith("/test/resources/com/liferay/source/formatter/")) {
            fileNameRegex = suppressionsFileLocation + fileNameRegex;
        }
        if (checkType.equals((Object)CheckType.SOURCE_CHECK)) {
            this._addSourceCheckSuppression(checkName, fileNameRegex);
        } else {
            this._addCheckstyleSuppression(checkName, fileNameRegex);
        }
    }

    public FilterSet getCheckstyleFilterSet() {
        return this._checkstyleFilterSet;
    }

    public boolean isSuppressed(String sourceCheckName, String absolutePath) {
        List<String> fileNameRegexes = this._sourceChecksSuppressionsMap.get(sourceCheckName);
        if (fileNameRegexes == null) {
            return false;
        }
        for (String fileNameRegex : fileNameRegexes) {
            if (!absolutePath.matches(".*" + fileNameRegex)) continue;
            return true;
        }
        return false;
    }

    private void _addCheckstyleSuppression(String checkName, String fileNameRegex) {
        this._checkstyleFilterSet.addFilter((Filter)new SuppressFilterElement(fileNameRegex, checkName, null, null, null, null));
    }

    private void _addSourceCheckSuppression(String checkName, String fileNameRegex) {
        List<String> fileNameRegexes = this._sourceChecksSuppressionsMap.get(checkName);
        if (fileNameRegexes == null) {
            fileNameRegexes = new ArrayList<String>();
        }
        fileNameRegexes.add(fileNameRegex);
        this._sourceChecksSuppressionsMap.put(checkName, fileNameRegexes);
    }
}

