/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;

public class VariableDeclarationAsUsedCheck
extends BaseCheck {
    private static final String _MSG_VARIABLE_DECLARATION_MOVE_AFTER_BRANCHING_STATEMENT = "variable.declaration.move.after.branching.statement";
    private static final String _MSG_VARIABLE_DECLARATION_MOVE_INSIDE_IF_STATEMENT = "variable.declaration.move.inside.if.statement";
    private static final String _MSG_VARIABLE_DECLARATION_NOT_NEEDED = "variable.declaration.not.needed";

    public int[] getDefaultTokens() {
        return new int[]{8, 9};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        List<DetailAST> variableDefinitionDetailASTList = this.getAllChildTokens(detailAST, true, 10);
        for (DetailAST variableDefinitionDetailAST : variableDefinitionDetailASTList) {
            this._checkVariableDefinition(detailAST, variableDefinitionDetailAST);
        }
    }

    private void _checkInline(DetailAST detailAST, String variableName, DetailAST assignMethodCallDetailAST, DetailAST identDetailAST, List<DetailAST> dependentIdentDetailASTList) {
        if (assignMethodCallDetailAST == null || !variableName.equals(identDetailAST.getText())) {
            return;
        }
        DetailAST parentDetailAST = identDetailAST.getParent();
        if (parentDetailAST.getType() == 132) {
            parentDetailAST = parentDetailAST.getParent();
        }
        if (parentDetailAST.getType() != 28) {
            return;
        }
        int endLineNumber = this.getEndLineNumber(detailAST);
        for (DetailAST dependentIdentDetailAST : dependentIdentDetailASTList) {
            if (!variableName.equals(dependentIdentDetailAST.getText()) || this.equals(dependentIdentDetailAST, identDetailAST) || dependentIdentDetailAST.getLineNo() <= endLineNumber) continue;
            return;
        }
        if (this._hasChainStyle(assignMethodCallDetailAST, "build", "map", "put")) {
            if (this._isInsideStatementClause(identDetailAST)) {
                return;
            }
        } else {
            if (this.getStartLineNumber(assignMethodCallDetailAST) != this.getEndLineNumber(assignMethodCallDetailAST) || this._isInsideStatementClause(identDetailAST) && this.hasParentWithTokenType(identDetailAST, RELATIONAL_OPERATOR_TOKEN_TYPES)) {
                return;
            }
            if (!this._matchesGetOrSetCall(assignMethodCallDetailAST, identDetailAST, variableName)) {
                return;
            }
        }
        if ((parentDetailAST = this.getParentWithTokenType(identDetailAST, 181, 85, 91, 136, 67, 95, 84)) != null && parentDetailAST.getLineNo() >= detailAST.getLineNo()) {
            return;
        }
        int emptyLineCount = 0;
        for (int i = detailAST.getLineNo(); i <= identDetailAST.getLineNo(); ++i) {
            if (!Validator.isNull(this.getLine(i - 1)) || ++emptyLineCount <= 1) continue;
            return;
        }
        this.log(detailAST, _MSG_VARIABLE_DECLARATION_NOT_NEEDED, new Object[]{variableName, identDetailAST.getLineNo()});
    }

    private void _checkMoveAfterBranchingStatement(DetailAST detailAST, DetailAST variableDefinitionDetailAST, String variableName, DetailAST firstDependentIdentDetailAST) {
        int endLineNumber = this.getEndLineNumber(variableDefinitionDetailAST);
        DetailAST lastBranchingStatementDetailAST = this._getLastBranchingStatementDetailAST(detailAST, endLineNumber, this._getClosestParentLineNumber(firstDependentIdentDetailAST, endLineNumber));
        if (lastBranchingStatementDetailAST != null) {
            this.log(variableDefinitionDetailAST, _MSG_VARIABLE_DECLARATION_MOVE_AFTER_BRANCHING_STATEMENT, new Object[]{variableName, lastBranchingStatementDetailAST.getText(), lastBranchingStatementDetailAST.getLineNo()});
        }
    }

    private void _checkMoveInsideIfStatement(DetailAST variableDefinitionDetailAST, DetailAST nameDetailAST, String variableName, List<DetailAST> dependentIdentDetailASTList) {
        DetailAST ifStatementDetailAST = this._getIfStatementDetailAST(dependentIdentDetailASTList.get(0), this.getEndLineNumber(variableDefinitionDetailAST));
        if (ifStatementDetailAST == null) {
            return;
        }
        DetailAST parentDetailAST = this.getParentWithTokenType(ifStatementDetailAST, 181, 85, 91, 136, 67, 95, 84);
        if (parentDetailAST != null && parentDetailAST.getLineNo() >= variableDefinitionDetailAST.getLineNo()) {
            return;
        }
        DetailAST slistDetailAST = ifStatementDetailAST.findFirstToken(7);
        DetailAST lastDependentIdentDetailAST = dependentIdentDetailASTList.get(dependentIdentDetailASTList.size() - 1);
        if (this.getEndLineNumber(slistDetailAST) > lastDependentIdentDetailAST.getLineNo()) {
            this.log(nameDetailAST, _MSG_VARIABLE_DECLARATION_MOVE_INSIDE_IF_STATEMENT, new Object[]{variableName, ifStatementDetailAST.getLineNo()});
        }
    }

    private void _checkVariableDefinition(DetailAST detailAST, DetailAST variableDefinitionDetailAST) {
        if (this.hasParentWithTokenType(variableDefinitionDetailAST, 156, 35)) {
            return;
        }
        DetailAST nameDetailAST = variableDefinitionDetailAST.findFirstToken(58);
        List<DetailAST> dependentIdentDetailASTList = this.getDependentIdentDetailASTList(variableDefinitionDetailAST, variableDefinitionDetailAST.getLineNo());
        if (dependentIdentDetailASTList.isEmpty()) {
            return;
        }
        String variableName = nameDetailAST.getText();
        DetailAST firstDependentIdentDetailAST = dependentIdentDetailASTList.get(0);
        if (!this._containsMethodName(variableDefinitionDetailAST, StringBundler.concat("_?(add|channel|close|copy|create|delete|execute|import|", "manage|next|open|post|put|read|register|resolve|run|send|", "test|transform|unzip|update|zip)([A-Z].*)?"), "currentTimeMillis", "nextVersion", "toString") && !this._containsVariableType(variableDefinitionDetailAST, "ActionQueue", "File")) {
            this._checkMoveAfterBranchingStatement(detailAST, variableDefinitionDetailAST, variableName, firstDependentIdentDetailAST);
            this._checkMoveInsideIfStatement(variableDefinitionDetailAST, nameDetailAST, variableName, dependentIdentDetailASTList);
        }
        this._checkInline(variableDefinitionDetailAST, variableName, this._getAssignMethodCallDetailAST(variableDefinitionDetailAST), firstDependentIdentDetailAST, dependentIdentDetailASTList);
    }

    private boolean _containsMethodName(DetailAST variableDefinitionDetailAST, String ... methodNameRegexArray) {
        List<DetailAST> methodCallDetailASTList = this.getAllChildTokens(variableDefinitionDetailAST, true, 27);
        for (DetailAST methodCallDetailAST : methodCallDetailASTList) {
            String methodName = this.getMethodName(methodCallDetailAST);
            for (String methodNameRegex : methodNameRegexArray) {
                if (!methodName.matches(methodNameRegex)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean _containsVariableType(DetailAST variableDefinitionDetailAST, String ... variableTypeNames) {
        List<DetailAST> identDetailASTList = this.getAllChildTokens(variableDefinitionDetailAST, true, 58);
        for (DetailAST identDetailAST : identDetailASTList) {
            if (!ArrayUtil.contains(variableTypeNames, this.getVariableTypeName(identDetailAST, identDetailAST.getText(), false))) continue;
            return true;
        }
        return false;
    }

    private DetailAST _getAssignMethodCallDetailAST(DetailAST variableDefinitionDetailAST) {
        DetailAST assignDetailAST = variableDefinitionDetailAST.findFirstToken(80);
        if (assignDetailAST == null) {
            return null;
        }
        DetailAST firstChildDetailAST = assignDetailAST.getFirstChild();
        if (firstChildDetailAST == null || firstChildDetailAST.getType() != 28) {
            return null;
        }
        if ((firstChildDetailAST = firstChildDetailAST.getFirstChild()) != null && firstChildDetailAST.getType() == 27) {
            return firstChildDetailAST;
        }
        return null;
    }

    private int _getClosestParentLineNumber(DetailAST firstNameDetailAST, int lineNumber) {
        int closestLineNumber = firstNameDetailAST.getLineNo();
        DetailAST parentDetailAST = firstNameDetailAST.getParent();
        while (parentDetailAST.getLineNo() > lineNumber) {
            closestLineNumber = parentDetailAST.getLineNo();
            parentDetailAST = parentDetailAST.getParent();
        }
        return closestLineNumber;
    }

    private DetailAST _getIfStatementDetailAST(DetailAST detailAST, int lineNumber) {
        DetailAST ifStatementDetailAST = null;
        DetailAST slistDetailAST = this.getParentWithTokenType(detailAST, 7);
        while (slistDetailAST != null && slistDetailAST.getLineNo() >= lineNumber) {
            DetailAST parentDetailAST = slistDetailAST.getParent();
            if (parentDetailAST.getType() == 83) {
                ifStatementDetailAST = parentDetailAST;
            }
            slistDetailAST = this.getParentWithTokenType(slistDetailAST, 7);
        }
        return ifStatementDetailAST;
    }

    private DetailAST _getLastBranchingStatementDetailAST(DetailAST detailAST, int start, int end) {
        DetailAST lastBranchingStatementDetailAST = null;
        List<DetailAST> branchingStatementDetailASTList = this.getAllChildTokens(detailAST, true, 86, 87, 88);
        for (DetailAST branchingStatementDetailAST : branchingStatementDetailASTList) {
            int lineNumber = this.getEndLineNumber(branchingStatementDetailAST);
            if (start >= lineNumber || end <= lineNumber) continue;
            DetailAST branchedStatementDetailAST = null;
            branchedStatementDetailAST = branchingStatementDetailAST.getType() == 86 || branchingStatementDetailAST.getType() == 87 ? this.getParentWithTokenType(branchingStatementDetailAST, 85, 91, 84) : this.getParentWithTokenType(branchingStatementDetailAST, 8, 181, 9);
            if (branchedStatementDetailAST == null || branchedStatementDetailAST.getLineNo() >= start || lastBranchingStatementDetailAST != null && branchingStatementDetailAST.getLineNo() <= lastBranchingStatementDetailAST.getLineNo()) continue;
            lastBranchingStatementDetailAST = branchingStatementDetailAST;
        }
        return lastBranchingStatementDetailAST;
    }

    private boolean _hasChainStyle(DetailAST methodCallDetailAST, String ... methodNames) {
        int startLineNumber = this.getStartLineNumber(methodCallDetailAST);
        String line = this.getLine(startLineNumber - 1);
        if (!line.endsWith("(") || ToolsUtil.getLevel(line) != 1) {
            return false;
        }
        for (String methodName : methodNames) {
            if (!line.endsWith("." + methodName + "(")) continue;
            int level = 1;
            for (int i = startLineNumber + 1; i <= this.getEndLineNumber(methodCallDetailAST); ++i) {
                line = StringUtil.trim(this.getLine(i - 1));
                if (line.startsWith(").") && level == 1) {
                    return true;
                }
                level += ToolsUtil.getLevel(line);
            }
        }
        return false;
    }

    private boolean _isInsideStatementClause(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        DetailAST grandParentDetailAST;
        while ((grandParentDetailAST = parentDetailAST.getParent()) != null) {
            if (grandParentDetailAST.getType() == 91) {
                return parentDetailAST.getType() == 36 || parentDetailAST.getType() == 156 || parentDetailAST.getType() == 35 || parentDetailAST.getType() == 37;
            }
            if (grandParentDetailAST.getType() == 95) {
                return parentDetailAST.getType() == 176;
            }
            if (grandParentDetailAST.getType() == 84) {
                return parentDetailAST.getType() == 28;
            }
            parentDetailAST = grandParentDetailAST;
        }
        return false;
    }

    private boolean _matchesGetOrSetCall(DetailAST assignMethodCallDetailAST, DetailAST identDetailAST, String variableName) {
        String methodName = this.getMethodName(assignMethodCallDetailAST);
        if (methodName.matches("(?i)get" + variableName)) {
            return true;
        }
        DetailAST parentDetailAST = identDetailAST.getParent();
        if (parentDetailAST.getType() != 28) {
            return false;
        }
        if ((parentDetailAST = parentDetailAST.getParent()).getType() != 34 || parentDetailAST.getChildCount() != 1) {
            return false;
        }
        if ((parentDetailAST = parentDetailAST.getParent()).getType() != 27) {
            return false;
        }
        methodName = this.getMethodName(parentDetailAST);
        return methodName.matches("(?i)set" + variableName);
    }
}

