/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.io.IOException;

public class GradleIndentationCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        return this._checkIndentation(content);
    }

    private String _checkIndentation(String content) throws IOException {
        boolean insideIfStatement = false;
        boolean insideQuotes = false;
        int tabCount = 0;
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if (!(insideIfStatement || insideQuotes || line.matches("^\\s*['\"].*['\"].*[\\)\\+]$"))) {
                    line = this._checkIndentation(line, tabCount);
                }
                sb.append(line);
                sb.append("\n");
                String trimmedLine = StringUtil.trim(line);
                if ((trimmedLine.startsWith("else if (") || trimmedLine.startsWith("if (")) && !line.endsWith("{")) {
                    insideIfStatement = true;
                } else if (insideIfStatement) {
                    if (line.endsWith("{")) {
                        insideIfStatement = false;
                        ++tabCount;
                    }
                } else {
                    tabCount = this._getTabCount(line, insideQuotes, tabCount);
                }
                if (line.indexOf(this._getQuoteString(line)) == -1) continue;
                insideQuotes = !insideQuotes;
            }
        }
        if (sb.length() > 0) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }

    private String _checkIndentation(String line, int expectedTabCount) {
        if (Validator.isNull(line)) {
            return line;
        }
        int leadingTabCount = this.getLeadingTabCount(line);
        if (line.matches("\t*[\\}\\]\\)].*")) {
            --expectedTabCount;
        }
        if (leadingTabCount == expectedTabCount) {
            return line;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < expectedTabCount; ++i) {
            sb.append("\t");
        }
        sb.append(StringUtil.trimLeading(line));
        return sb.toString();
    }

    private String _getQuoteString(String line) {
        if (line.indexOf("'''") != -1) {
            return "'''";
        }
        return "\"\"\"";
    }

    private int _getTabCount(String line, boolean insideQuotes, int tabCount) {
        int y;
        int x;
        String quoteString = this._getQuoteString(line);
        String text = line;
        if (line.indexOf(quoteString) != -1) {
            if (insideQuotes) {
                x = quoteString.length();
                text = text.substring(line.indexOf(quoteString) + x);
            } else {
                text = text.substring(0, line.indexOf(quoteString));
            }
        }
        if (insideQuotes && line.equals(text)) {
            return tabCount;
        }
        if (text.matches("^\\s*Matcher\\s+.*") || text.matches("^\\s*Pattern\\s+.*")) {
            return tabCount;
        }
        if (text.contains(" ==~ /") && (y = text.indexOf("/", (x = text.indexOf(" ==~ /")) + 6)) != -1) {
            text = text.substring(0, x) + text.substring(y + 1);
        }
        tabCount += this.getLevel(text, "([{", "}])");
        text = StringUtil.removeSubstrings(text, "([{", "}])");
        tabCount += this.getLevel(text, "[{", "}]");
        text = StringUtil.removeSubstrings(text, "[{", "}]");
        return this.getLevel(text, new String[]{"{", "[", "("}, new String[]{"}", "]", ")"}, tabCount);
    }
}

