/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseStylingCheck;
import com.liferay.source.formatter.checks.util.JSPSourceUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPStylingCheck
extends BaseStylingCheck {
    private static final Pattern _emptyJavaSourceTagPattern = Pattern.compile("\n\t*<%\\!?\n+\t*%>(\n|\\Z)");
    private static final Pattern _incorrectClosingTagPattern = Pattern.compile("\n(\t*)\t((?!<\\w).)* />\n");
    private static final Pattern _incorrectLineBreakPattern1 = Pattern.compile("[\n\t]\\} ?(catch|else|finally) ");
    private static final Pattern _incorrectLineBreakPattern2 = Pattern.compile("=(\n\\s*).*;\n");
    private static final Pattern _incorrectLineBreakPattern3 = Pattern.compile("<%= *\\S((?!%>).)*\n");
    private static final Pattern _incorrectLineBreakPattern4 = Pattern.compile("(\n(\t*)<(\\w+)>)(<\\w+>.*)(</\\3>\n)");
    private static final Pattern _incorrectSingleLineJavaSourcePattern = Pattern.compile("(\t*)(<% (.*) %>)\n");
    private static final Pattern _portletNamespacePattern = Pattern.compile("=([\"'])<portlet:namespace />(\\w+\\(.*?)\\1");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        content = this._formatLineBreak(fileName, content);
        content = this._fixEmptyJavaSourceTag(content);
        content = this._fixIncorrectClosingTag(content);
        content = this._fixIncorrectSingleLineJavaSource(content);
        content = StringUtil.replace(content, new String[]{"alert('<%= LanguageUtil.", "alert(\"<%= LanguageUtil.", "confirm('<%= LanguageUtil.", "confirm(\"<%= LanguageUtil.", ";;\n"}, new String[]{"alert('<%= UnicodeLanguageUtil.", "alert(\"<%= UnicodeLanguageUtil.", "confirm('<%= UnicodeLanguageUtil.", "confirm(\"<%= UnicodeLanguageUtil.", ";\n"});
        content = content.replaceAll("'<%= (\"[^.(\\[\"]+\") %>'", "$1");
        content = content.replaceAll("((['\"])<%= ((?<!%>).)*?)\\\\(\".+?)\\\\(\".*?%>\\2)", "$1$4$5");
        Matcher matcher = _portletNamespacePattern.matcher(content);
        while (matcher.find()) {
            String s = matcher.group(2);
            if (!s.endsWith(")") || this.getLevel(s) != 0) continue;
            return StringUtil.insert(content, ";", matcher.end() - 1);
        }
        return this.formatStyling(content);
    }

    @Override
    protected boolean isJavaSource(String content, int pos) {
        return JSPSourceUtil.isJavaSource(content, pos, true);
    }

    private String _fixEmptyJavaSourceTag(String content) {
        Matcher matcher = _emptyJavaSourceTagPattern.matcher(content);
        if (matcher.find()) {
            return StringUtil.removeSubstring(content, matcher.group());
        }
        return content;
    }

    private String _fixIncorrectClosingTag(String content) {
        Matcher matcher = _incorrectClosingTagPattern.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, " />\n", "\n" + matcher.group(1) + "/>\n", matcher.end(1));
        }
        return content;
    }

    private String _fixIncorrectSingleLineJavaSource(String content) {
        Matcher matcher = _incorrectSingleLineJavaSourcePattern.matcher(content);
        while (matcher.find()) {
            String javaSource = matcher.group(3);
            if (javaSource.contains("<%")) continue;
            String indent = matcher.group(1);
            StringBundler sb = new StringBundler(6);
            sb.append("<%\n");
            sb.append(indent);
            sb.append(StringUtil.trim(javaSource));
            sb.append("\n");
            sb.append(indent);
            sb.append("%>");
            return StringUtil.replaceFirst(content, matcher.group(2), sb.toString(), matcher.start());
        }
        return content;
    }

    private String _formatLineBreak(String fileName, String content) {
        Matcher matcher = _incorrectLineBreakPattern1.matcher(content);
        while (matcher.find()) {
            if (JSPSourceUtil.isJSSource(content, matcher.start(1))) continue;
            this.addMessage(fileName, "There should be a line break after '}'", this.getLineNumber(content, matcher.start(1)));
        }
        matcher = _incorrectLineBreakPattern2.matcher(content);
        while (matcher.find()) {
            if (!JSPSourceUtil.isJavaSource(content, matcher.start())) continue;
            return StringUtil.replaceFirst(content, matcher.group(1), " ", matcher.start());
        }
        matcher = _incorrectLineBreakPattern3.matcher(content);
        while (matcher.find()) {
            this.addMessage(fileName, "There should be a line break after '<%='", this.getLineNumber(content, matcher.start()));
        }
        matcher = _incorrectLineBreakPattern4.matcher(content);
        return matcher.replaceAll("$1\n\t$2$4\n$2$5");
    }
}

