/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GetterUtilCheck
extends BaseFileCheck {
    private static final Pattern _getterUtilGetPattern = Pattern.compile("\\WGetterUtil\\.get(Boolean|Double|Float|Integer|Long|Number|Object|Short|String)\\(", 32);
    private static final Pattern _paramUtilGetPattern = Pattern.compile("\\WParamUtil\\.get(Boolean|Double|Float|Integer|Long|Number|Short|String)\\(", 32);

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws ReflectiveOperationException {
        this._checkDefaultValues(fileName, content, _getterUtilGetPattern, 2);
        this._checkDefaultValues(fileName, content, _paramUtilGetPattern, 3);
        return content;
    }

    private void _checkDefaultValues(String fileName, String content, Pattern pattern, int parameterCount) throws ReflectiveOperationException {
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            List<String> parameterList;
            if (ToolsUtil.isInsideQuotes(content, matcher.start() + 1) || (parameterList = JavaSourceUtil.getParameterList(content.substring(matcher.start() + 1))).size() != parameterCount) continue;
            String defaultVariableName = "DEFAULT_" + StringUtil.toUpperCase(matcher.group(1));
            Field defaultValuefield = GetterUtil.class.getDeclaredField(defaultVariableName);
            String defaultValue = String.valueOf(defaultValuefield.get(null));
            defaultValue = defaultValue.replaceFirst("\\.0", "");
            String value = parameterList.get(parameterCount - 1);
            String formattedValue = value.replaceFirst("0(\\.0)?[dDfFlL]?", "0");
            if (formattedValue.equals("StringPool.BLANK")) {
                formattedValue = "";
            }
            if (!Objects.equals(formattedValue, defaultValue)) continue;
            this.addMessage(fileName, "No need to pass default value '" + value + "'", this.getLineNumber(content, matcher.start()));
        }
    }
}

