/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPServiceUtilCheck
extends BaseFileCheck {
    private static final Pattern _serviceUtilPattern = Pattern.compile("\\b[A-Z]\\w+ServiceUtil\\.");

    @Override
    public boolean isModuleSourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        Matcher matcher = _serviceUtilPattern.matcher(content);
        if (matcher.find()) {
            this.addMessage(fileName, "Do not use *ServiceUtil in module jsp", this.getLineNumber(content, matcher.start()));
        }
        return content;
    }
}

