/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseEmptyLinesCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaEmptyLinesCheck
extends BaseEmptyLinesCheck {
    private static final Pattern _redundantEmptyLinePattern = Pattern.compile("\n(.*)-> \\{\n\n[\t ]*(?!// )\\S");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        content = this.fixMissingEmptyLines(absolutePath, content);
        content = this.fixMissingEmptyLinesAroundComments(content);
        content = this.fixRedundantEmptyLines(content);
        content = this.fixMissingEmptyLineAfterSettingVariable(content);
        content = this._fixRedundantEmptyLineInLambdaExpression(content);
        content = this._fixIncorrectEmptyLineInsideStatement(content);
        return content;
    }

    private String _fixIncorrectEmptyLineInsideStatement(String content) {
        int pos = -1;
        block0: while (true) {
            String lineAfter;
            String lineBefore;
            String s1;
            int previousPos = pos;
            if ((pos = content.indexOf("\n\n", pos + 1)) == -1) {
                return content;
            }
            if (previousPos == -1 || this.getLevel(s1 = content.substring(previousPos, pos)) <= 0 || (lineBefore = StringUtil.trim(this.getLine(content, this.getLineNumber(content, previousPos)))).startsWith("//") || (lineAfter = StringUtil.trim(this.getLine(content, this.getLineNumber(content, pos + 2)))).startsWith("//")) continue;
            int x = s1.length();
            while ((x = s1.lastIndexOf("(", x - 1)) != -1) {
                String s3;
                String s2 = s1.substring(x);
                if (this.getLevel(s2) <= 0) continue;
                if (this.getLevel(s2, "{", "}") <= 0 && !(s3 = StringUtil.trim(s1.substring(0, x))).endsWith("\ttry")) break block0;
                continue block0;
            }
            break;
        }
        return StringUtil.replaceFirst(content, "\n\n", "\n", pos);
    }

    private String _fixRedundantEmptyLineInLambdaExpression(String content) {
        Matcher matcher = _redundantEmptyLinePattern.matcher(content);
        while (matcher.find()) {
            if (this.getLevel(matcher.group(1)) != 0) continue;
            return StringUtil.replaceFirst(content, "\n\n", "\n", matcher.start());
        }
        return content;
    }
}

