/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaServiceUtilCheck
extends BaseFileCheck {
    private static final Pattern _serviceUtilPattern = Pattern.compile("import com\\.liferay\\.[a-z]+\\.kernel\\..*ServiceUtil;");

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        String className = JavaSourceUtil.getClassName(fileName);
        if (className.equals("BaseServiceImpl") || !className.endsWith("ServiceImpl")) {
            return content;
        }
        Matcher matcher = _serviceUtilPattern.matcher(content);
        if (matcher.find()) {
            this.addMessage(fileName, "Do not use a portal-kernel *ServiceUtil in a *ServiceImpl class, create a reference via service.xml instead");
        }
        return content;
    }
}

