/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertiesLiferayPluginPackageLiferayVersionsCheck
extends BaseFileCheck {
    private static final Pattern _liferayVersionsPattern = Pattern.compile("\nliferay-versions=(.*)\n");

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (fileName.endsWith("/liferay-plugin-package.properties")) {
            return this._fixIncorrectLiferayVersions(absolutePath, content);
        }
        return content;
    }

    private String _fixIncorrectLiferayVersions(String absolutePath, String content) throws IOException {
        if (!this.isPortalSource() || !this.isModulesApp(absolutePath, false)) {
            return content;
        }
        Matcher matcher = _liferayVersionsPattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        boolean privateApp = this.isModulesApp(absolutePath, true);
        String portalVersion = this.getPortalVersion(privateApp);
        if (Validator.isNull(portalVersion)) {
            return content;
        }
        return StringUtil.replace(content, "liferay-versions=" + matcher.group(1), "liferay-versions=" + portalVersion + "+", matcher.start());
    }
}

