/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertiesLongLinesCheck
extends BaseFileCheck {
    private static final Pattern _commentsPattern = Pattern.compile("(    (?!# Env: )# (?! ).+)(\n    # (?! ).+)*");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (absolutePath.endsWith("-portal.properties") || absolutePath.matches(".*\\/portal-impl\\/src\\/portal[\\w-]+\\.properties")) {
            return content;
        }
        Matcher matcher = _commentsPattern.matcher(content);
        while (matcher.find()) {
            String match = matcher.group();
            String comment = StringUtil.removeSubstring(match, "\n    #");
            if (StringUtil.equals(match, comment = this._splitComment(comment))) continue;
            return StringUtil.replaceFirst(content, match, comment, matcher.start());
        }
        return content;
    }

    private String _splitComment(String comment) {
        if (comment.length() <= this.getMaxLineLength()) {
            return comment;
        }
        int x = -1;
        x = comment.startsWith("    # See http:") ? comment.indexOf(32, 10) : comment.indexOf(32, 6);
        if (x == -1) {
            return comment;
        }
        if (x > this.getMaxLineLength()) {
            String s = "    # " + comment.substring(x + 1);
            return comment.substring(0, x) + "\n" + this._splitComment(s);
        }
        x = comment.lastIndexOf(32, this.getMaxLineLength());
        String s = "    # " + comment.substring(x + 1);
        return comment.substring(0, x) + "\n" + this._splitComment(s);
    }
}

