/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.tools.ImportPackage;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.comparator.ElementComparator;
import com.liferay.source.formatter.checks.util.SourceUtil;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class XMLFSBExcludeFileCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws DocumentException {
        if (fileName.endsWith("/fsb-exclude.xml")) {
            this._checkFSBExcludeXML(fileName, content);
        }
        return content;
    }

    private void _checkFSBExcludeXML(String fileName, String content) throws DocumentException {
        Document document = SourceUtil.readXML(content);
        Element rootElement = document.getRootElement();
        this.checkElementOrder(fileName, rootElement, "Match", null, new FSBExcludeMatchComparator());
        for (Element matchElement : rootElement.elements("Match")) {
            for (Element orElement : matchElement.elements("Or")) {
                this.checkElementOrder(fileName, orElement, "Bug", null, new ElementComparator("pattern"));
                this.checkElementOrder(fileName, orElement, "Class", null, new FSBExcludeClassComparator());
                this.checkElementOrder(fileName, orElement, "Method", null, new ElementComparator());
            }
        }
    }

    private class FSBExcludeMatchComparator
    extends FSBExcludeClassComparator {
        private FSBExcludeMatchComparator() {
        }

        @Override
        public String getElementName(Element element) {
            Element classElement = element.element("Class");
            if (classElement == null) {
                return null;
            }
            return classElement.attributeValue("name");
        }
    }

    private class FSBExcludeClassComparator
    extends ElementComparator {
        private FSBExcludeClassComparator() {
        }

        @Override
        public int compare(Element element1, Element element2) {
            String elementName1 = this.getElementName(element1);
            String elementName2 = this.getElementName(element2);
            if (elementName1 == null || elementName2 == null) {
                return 0;
            }
            ImportPackage importPackage1 = new ImportPackage(elementName1, false, elementName1);
            ImportPackage importPackage2 = new ImportPackage(elementName2, false, elementName2);
            return importPackage1.compareTo(importPackage2);
        }
    }
}

