/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.CharPool;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertiesPortalEnvironmentVariablesCheck
extends BaseFileCheck {
    private static final String _ENV_OVERRIDE_PREFIX = "LIFERAY_";
    private static final Map<Character, String> _charPoolChars = new HashMap<Character, String>(){
        {
            try {
                for (Field field : CharPool.class.getFields()) {
                    if (!Modifier.isStatic(field.getModifiers()) || field.getType() != Character.TYPE) continue;
                    this.put(Character.valueOf(field.getChar(null)), StringUtil.removeChar(field.getName(), '_'));
                }
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new ExceptionInInitializerError(reflectiveOperationException);
            }
        }
    };
    private static final Pattern _pattern = Pattern.compile("\n((    #( .*)?\n)*)((    ( |#?\\w).*\n)+)");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (!this.isPortalSource() || !absolutePath.matches(".*/portal-impl/src/portal(_.*)?\\.properties")) {
            return content;
        }
        return this._formatPortalProperties(content);
    }

    private String _encode(String s) {
        StringBundler sb = new StringBundler();
        sb.append(_ENV_OVERRIDE_PREFIX);
        for (char c : s.toCharArray()) {
            if (Character.isLowerCase(c)) {
                sb.append(Character.toUpperCase(c));
                continue;
            }
            sb.append('_');
            sb.append(_charPoolChars.get(Character.valueOf(c)));
            sb.append('_');
        }
        return sb.toString();
    }

    private String _formatPortalProperties(String content) {
        Matcher matcher = _pattern.matcher(content);
        while (matcher.find()) {
            String variablesContent = matcher.group(4);
            Set<String> environmentVariables = this._getEnvironmentVariables(variablesContent);
            if (environmentVariables.isEmpty()) continue;
            String commentBlock = matcher.group(1);
            StringBundler sb = new StringBundler();
            if (Validator.isNull(commentBlock)) {
                sb.append("\n");
                sb.append("    ");
                sb.append("#");
                sb.append("\n");
            }
            for (String environmentVariable : environmentVariables) {
                sb.append("    ");
                sb.append("# Env: ");
                sb.append(environmentVariable);
                sb.append("\n");
            }
            sb.append("    ");
            sb.append("#");
            sb.append("\n");
            String environmentVariablesComment = sb.toString();
            if (commentBlock.endsWith(environmentVariablesComment)) continue;
            return StringUtil.replaceFirst(content, variablesContent, environmentVariablesComment + variablesContent, matcher.start() - 1);
        }
        return content;
    }

    private Set<String> _getEnvironmentVariables(String s) {
        TreeSet<String> environmentVariables = new TreeSet<String>();
        for (String line : StringUtil.splitLines(s)) {
            int pos;
            String trimmedLine = StringUtil.trim(line);
            if (trimmedLine.startsWith("#")) {
                trimmedLine = trimmedLine.substring(1);
                trimmedLine = StringUtil.trim(trimmedLine);
            }
            if ((pos = trimmedLine.indexOf("=")) == -1) continue;
            environmentVariables.add(this._encode(trimmedLine.substring(0, pos)));
        }
        return environmentVariables;
    }
}

