/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringMethodsCheck
extends BaseFileCheck {
    private static final Pattern _singleLengthStringPattern = Pattern.compile("^(\".\"|StringPool\\.([A-Z_]+))$");
    private static final Pattern _stringReplacePattern = Pattern.compile("(\\w+)\\.replace\\(");
    private static final Pattern _stringUtilReplacePattern = Pattern.compile("StringUtil\\.(replace(First|Last)?)\\(");

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws ReflectiveOperationException {
        content = this._checkStringUtilReplaceCalls(fileName, content);
        if (this.isExcludedPath("run.outside.portal.excludes", absolutePath)) {
            this._checkStringReplaceCalls(fileName, content);
            return content;
        }
        this._checkInefficientStringMethods(fileName, content, "(\\w+)\\.equalsIgnoreCase\\(", "equalsIgnoreCase");
        this._checkInefficientStringMethods(fileName, content, "(\\w+)\\.join\\(", "merge");
        this._checkInefficientStringMethods(fileName, content, "(\\w+)\\.replace\\(", "replace");
        this._checkInefficientStringMethods(fileName, content, "(\\w+)\\.toLowerCase\\(\\)", "toLowerCase");
        this._checkInefficientStringMethods(fileName, content, "(\\w+)\\.toUpperCase\\(\\)", "toUpperCase");
        return content;
    }

    private void _checkInefficientStringMethods(String fileName, String content, String regex, String methodName) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            String s;
            if (!this.isJavaSource(content, matcher.start()) || !(s = matcher.group(1)).equals("String") && !Objects.equals(this.getVariableTypeName(content, content, s), "String")) continue;
            this.addMessage(fileName, "Use StringUtil." + methodName, this.getLineNumber(content, matcher.start(1)));
        }
    }

    private void _checkStringReplaceCalls(String fileName, String content) throws ReflectiveOperationException {
        Matcher matcher = _stringReplacePattern.matcher(content);
        while (matcher.find()) {
            List<String> parameterList;
            String variableName = matcher.group(1);
            if (!Objects.equals(this.getVariableTypeName(content, content, variableName), "String") || (parameterList = JavaSourceUtil.getParameterList(content.substring(matcher.start()))).size() != 2 || !this._isSingleLenghtString(parameterList.get(0)) || !this._isSingleLenghtString(parameterList.get(1))) continue;
            StringBundler sb = new StringBundler(5);
            sb.append("Use ");
            sb.append(variableName);
            sb.append(".replace(char, char) instead of ");
            sb.append(variableName);
            sb.append(".replace(CharSequence, CharSequence)");
            this.addMessage(fileName, sb.toString(), this.getLineNumber(content, matcher.start()));
        }
    }

    private String _checkStringUtilReplaceCalls(String fileName, String content) throws ReflectiveOperationException {
        if (content.contains("com.liferay.poshi.runner.util.StringUtil") || content.contains("package com.liferay.poshi.runner.util;")) {
            return content;
        }
        Matcher matcher = _stringUtilReplacePattern.matcher(content);
        while (matcher.find()) {
            List<String> parameterList;
            if (ToolsUtil.isInsideQuotes(content, matcher.start()) || (parameterList = JavaSourceUtil.getParameterList(content.substring(matcher.start()))).size() != 3) continue;
            if (matcher.group(2) == null) {
                String lastParameter = parameterList.get(2);
                String middleParameter = parameterList.get(1);
                if ((lastParameter.equals("\"\"") || lastParameter.equals("StringPool.BLANK")) && !middleParameter.startsWith("'") && !middleParameter.startsWith("CharPool.")) {
                    return this._fixReplaceWithBlankCall(content, parameterList, matcher.start());
                }
            }
            if (!this._isSingleLenghtString(parameterList.get(1))) continue;
            String methodName = matcher.group(1);
            StringBundler sb = new StringBundler(5);
            sb.append("Use StringUtil.");
            sb.append(methodName);
            sb.append("(String, char, char) or StringUtil.");
            sb.append(methodName);
            sb.append("(String, char, String) instead");
            this.addMessage(fileName, sb.toString(), this.getLineNumber(content, matcher.start()));
        }
        return content;
    }

    private String _fixReplaceWithBlankCall(String content, List<String> parameterList, int pos) {
        String call;
        int x = pos;
        while (ToolsUtil.getLevel(call = content.substring(pos, (x = content.indexOf(")", x + 1)) + 1), "(", ")") != 0 || ToolsUtil.getLevel(call, "{", "}") != 0) {
        }
        String replacement = StringBundler.concat("StringUtil.removeSubstring(", parameterList.get(0), ", ", parameterList.get(1), ")");
        return StringUtil.replaceFirst(content, call, replacement);
    }

    private boolean _isSingleLenghtString(String s) throws ReflectiveOperationException {
        Matcher singleLengthMatcher = _singleLengthStringPattern.matcher(s);
        if (!singleLengthMatcher.find()) {
            return false;
        }
        if (s.startsWith("\"")) {
            return true;
        }
        String fieldName = singleLengthMatcher.group(2);
        Field field = StringPool.class.getDeclaredField(fieldName);
        String value = (String)field.get(null);
        return value.length() == 1;
    }
}

