/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.parser;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaClassType {
    private static final String[] _JAVA_LANG_CLASS_NAMES = new String[]{"AbstractMethodError", "Appendable", "ArithmeticException", "ArrayIndexOutOfBoundsException", "ArrayStoreException", "AssertionError", "AutoCloseable", "Boolean", "BootstrapMethodError", "Byte", "Character", "CharSequence", "Class", "ClassCastException", "ClassCircularityError", "ClassFormatError", "ClassLoader", "ClassNotFoundException", "ClassValue", "Cloneable", "CloneNotSupportedException", "Comparable", "Compiler", "Deprecated", "Double", "Enum", "EnumConstantNotPresentException", "Error", "Exception", "ExceptionInInitializerError", "Float", "IllegalAccessError", "IllegalAccessException", "IllegalArgumentException", "IllegalMonitorStateException", "IllegalStateException", "IllegalThreadStateException", "IncompatibleClassChangeError", "IndexOutOfBoundsException", "InheritableThreadLocal", "InstantiationError", "InstantiationException", "Integer", "InternalError", "InterruptedException", "Iterable", "LinkageError", "Long", "Math", "NegativeArraySizeException", "NoClassDefFoundError", "NoSuchFieldError", "NoSuchFieldException", "NoSuchMethodError", "NoSuchMethodException", "NullPointerException", "Number", "NumberFormatException", "Object", "OutOfMemoryError", "Override", "Package", "Process", "ProcessBuilder", "Readable", "ReflectiveOperationException", "Runnable", "Runtime", "RuntimeException", "RuntimePermission", "SafeVarargs", "SecurityException", "SecurityManager", "Short", "StackOverflowError", "StackTraceElement", "StrictMath", "String", "StringBuffer", "StringBuilder", "StringIndexOutOfBoundsException", "SuppressWarnings", "System", "Thread", "Thread", "ThreadDeath", "ThreadGroup", "ThreadLocal", "Throwable", "TypeNotPresentException", "UnknownError", "UnsatisfiedLinkError", "UnsupportedClassVersionError", "UnsupportedOperationException", "VerifyError", "VirtualMachineError", "Void"};
    private static final Pattern _fullQualifiedNamePattern = Pattern.compile("^([a-z]\\w*\\.){2,}([A-Z].*)");
    private int _arrayDimension;
    private JavaClassType _extendedClassType;
    private final List<JavaClassType> _genericClassTypes = new ArrayList<JavaClassType>();
    private String _name;
    private String _packageName;
    private JavaClassType _superClassType;
    private boolean _varargs;

    public JavaClassType(String type, String classPackageName, List<String> importNames) {
        this._parseJavaClassType(type, classPackageName, importNames);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean fullyQualifiedName) {
        StringBundler sb = new StringBundler();
        if (fullyQualifiedName && Validator.isNotNull(this._packageName)) {
            sb.append(this._packageName);
            sb.append(".");
        }
        sb.append(this._name);
        if (this._extendedClassType != null) {
            sb.append(" extends ");
            sb.append(this._extendedClassType.toString(fullyQualifiedName));
            return sb.toString();
        }
        if (this._superClassType != null) {
            sb.append(" super ");
            sb.append(this._superClassType.toString(fullyQualifiedName));
            return sb.toString();
        }
        if (!this._genericClassTypes.isEmpty()) {
            sb.append("<");
            for (JavaClassType genericClassType : this._genericClassTypes) {
                sb.append(genericClassType.toString(fullyQualifiedName));
                sb.append(", ");
            }
            sb.setIndex(sb.index() - 1);
            sb.append(">");
        }
        for (int i = 0; i < this._arrayDimension; ++i) {
            sb.append("[]");
        }
        if (this._varargs) {
            sb.append("...");
        }
        return sb.toString();
    }

    private String _getPackageName(String classPackageName, List<String> importNames) {
        if (this._name.matches("[a-z].*") || this._name.length() == 1) {
            return "";
        }
        for (String importName : importNames) {
            if (importName.endsWith("." + this._name)) {
                return StringUtil.removeLast(importName, "." + this._name);
            }
            int x = this._name.length();
            while ((x = this._name.lastIndexOf(".", x - 1)) != -1) {
                String className = this._name.substring(0, x);
                if (!importName.endsWith("." + className)) continue;
                return StringUtil.removeLast(importName, "." + className);
            }
        }
        if (ArrayUtil.contains(_JAVA_LANG_CLASS_NAMES, this._name)) {
            return "java.lang";
        }
        return classPackageName;
    }

    private void _parseGenericClassTypes(String genericTypesString, String classPackageName, List<String> importNames) {
        int x = -1;
        while (true) {
            if ((x = genericTypesString.indexOf(",", x + 1)) == -1) {
                this._genericClassTypes.add(new JavaClassType(genericTypesString, classPackageName, importNames));
                return;
            }
            String genericType = genericTypesString.substring(0, x);
            if (ToolsUtil.getLevel(genericType, "<", ">") != 0) continue;
            this._genericClassTypes.add(new JavaClassType(genericType, classPackageName, importNames));
            genericTypesString = genericTypesString.substring(x + 1);
            x = -1;
        }
    }

    private void _parseJavaClassType(String type, String classPackageName, List<String> importNames) {
        int x;
        type = StringUtil.trim(type);
        type = type.replaceAll("\\.\n", ".");
        type = type.replaceAll("\n", " ");
        if ((type = type.replaceAll("\t+ *", "")).startsWith("? extends ")) {
            this._name = "?";
            this._extendedClassType = new JavaClassType(type.substring(10), classPackageName, importNames);
            return;
        }
        if (type.startsWith("? super ")) {
            this._name = "?";
            this._superClassType = new JavaClassType(type.substring(8), classPackageName, importNames);
            return;
        }
        Matcher matcher = _fullQualifiedNamePattern.matcher(type);
        if (matcher.find()) {
            this._packageName = type.substring(0, matcher.end(1) - 1);
            type = StringUtil.trim(matcher.group(2));
        }
        if ((x = type.indexOf("<")) != -1) {
            int y = type.lastIndexOf(">");
            if (y == -1) {
                return;
            }
            this._parseGenericClassTypes(type.substring(x + 1, y), classPackageName, importNames);
            type = type.substring(0, x) + type.substring(y + 1);
        }
        if (type.endsWith("...")) {
            this._varargs = true;
            type = StringUtil.trim(type.substring(0, type.length() - 3));
        }
        while (type.endsWith("[]")) {
            ++this._arrayDimension;
            type = StringUtil.trim(type.substring(0, type.length() - 2));
        }
        this._name = type;
        if (this._packageName == null) {
            this._packageName = this._getPackageName(classPackageName, importNames);
        }
    }
}

