/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.pql;

import com.liferay.poshi.core.pql.PQLEntity;
import com.liferay.poshi.core.pql.PQLModifier;
import java.util.Properties;

public class PQLValue
extends PQLEntity {
    public PQLValue(String value) throws Exception {
        super(value);
        this._validateValue(value);
    }

    @Override
    public Object getPQLResult(Properties properties) throws Exception {
        return this.getObjectValue(this.getPQL());
    }

    protected Object getObjectValue(String value) throws Exception {
        this._validateValue(value);
        if (value == null) {
            return null;
        }
        if (value.startsWith("'") && value.endsWith("'") || value.startsWith("\"") && value.endsWith("\"")) {
            value = value.substring(1, value.length() - 1);
        } else if (value.contains(" ")) {
            throw new Exception("Invalid value: " + value);
        }
        if (value.equals("null")) {
            return null;
        }
        Object objectValue = value.equals("true") || value.equals("false") ? Boolean.valueOf(value) : (value.matches("\\d+\\.\\d+") ? Double.valueOf(value) : (value.matches("\\d+") ? Integer.valueOf(value) : value));
        PQLModifier pqlModifier = this.getPQLModifier();
        if (pqlModifier != null) {
            objectValue = pqlModifier.getPQLResult(objectValue);
        }
        return objectValue;
    }

    private void _validateValue(String value) throws Exception {
        if (value == null) {
            return;
        }
        if ((value = PQLValue.removeModifierFromPQL(value)).startsWith("'") && value.endsWith("'") || value.startsWith("\"") && value.endsWith("\"")) {
            return;
        }
        if (value.contains(" ")) {
            throw new Exception("Invalid value: " + value);
        }
    }
}

