/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class PythonSourceUtil {
    public static String getNestedStatementIndent(String statement) {
        String[] lines = StringUtil.splitLines(statement);
        if (lines.length <= 1) {
            return "";
        }
        for (int i = 1; i < lines.length; ++i) {
            String line = lines[i];
            String indent = line.replaceFirst("^([\t ]+).+", "$1");
            if (indent.equals(line)) continue;
            return indent;
        }
        return "";
    }

    public static List<String> getPythonStatements(String content, String indent) {
        ArrayList<String> statements = new ArrayList<String>();
        String[] lines = content.split("\n");
        StringBundler sb = new StringBundler();
        boolean insideMethod = false;
        for (String line : lines) {
            if (Validator.isNull(line.trim())) {
                sb.append("\n");
                continue;
            }
            if (!line.startsWith(indent)) continue;
            String s = line.substring(indent.length(), indent.length() + 1);
            String trimmedLine = line.trim();
            if (!(s.equals(" ") || s.equals("\t") || sb.length() == 0 || insideMethod)) {
                sb.setIndex(sb.index() - 1);
                statements.add(sb.toString());
                sb.setIndex(0);
            }
            if (trimmedLine.startsWith("def ") && !trimmedLine.endsWith("):") || insideMethod && trimmedLine.endsWith("):")) {
                insideMethod ^= true;
            }
            sb.append(line);
            sb.append("\n");
        }
        statements.add(sb.toString());
        return statements;
    }
}

