/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.json.JSONObjectImpl;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class UpgradeRemovedAPICheck
extends BaseCheck {
    private static final String _MSG_CLASS_NOT_FOUND = "class.not.found";
    private static final String _MSG_METHOD_NOT_FOUND = "method.not.found";
    private final Map<String, JSONObject> _javaClassesJSONObjectMap = new HashMap<String, JSONObject>();

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST != null || AnnotationUtil.containsAnnotation((DetailAST)detailAST, (String)"Deprecated")) {
            return;
        }
        String upgradeFromVersion = this.getAttributeValue("upgrade.from.version");
        String upgradeToVersion = this.getAttributeValue("upgrade.to.version");
        try {
            JSONObject upgradeFromJavaClassesJSONObject = this._getJavaClassesJSONObject(upgradeFromVersion);
            JSONObject upgradeToJavaClassesJSONObject = this._getJavaClassesJSONObject(upgradeToVersion);
            List<String> removedImportNames = this._getRemovedImportNames(detailAST, upgradeFromJavaClassesJSONObject, upgradeToJavaClassesJSONObject, upgradeToVersion);
            this._checkRemovedMethods(detailAST, removedImportNames, upgradeFromJavaClassesJSONObject, upgradeToJavaClassesJSONObject, upgradeToVersion);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void _checkRemovedMethods(DetailAST detailAST, List<String> removedImportNames, JSONObject upgradeFromJavaClassesJSONObject, JSONObject upgradeToJavaClassesJSONObject, String upgradeToVersion) {
        List<DetailAST> methodCallDetailASTList = this.getAllChildTokens(detailAST, true, 27);
        for (DetailAST methodCallDetailAST : methodCallDetailASTList) {
            List<String> parameterTypes;
            String methodName;
            MethodStatus fromUpgradeMethodStatus;
            String variableTypeName;
            DetailAST dotDetailAST = methodCallDetailAST.getFirstChild();
            if (dotDetailAST.getType() != 59) continue;
            DetailAST firstChildDetailAST = dotDetailAST.getFirstChild();
            DetailAST lastChildDetailAST = dotDetailAST.getLastChild();
            if (firstChildDetailAST.getType() != 58 || lastChildDetailAST.getType() != 58 || !(variableTypeName = this.getVariableTypeName(firstChildDetailAST, firstChildDetailAST.getText(), false, true)).startsWith("com.liferay.") || removedImportNames.contains(variableTypeName) || !(fromUpgradeMethodStatus = this._getMethodStatus(upgradeFromJavaClassesJSONObject, variableTypeName, methodName = lastChildDetailAST.getText(), parameterTypes = this._getParameterTypes(methodCallDetailAST))).equals((Object)MethodStatus.METHOD_FOUND)) continue;
            MethodStatus toUpgradeMethodStatus = this._getMethodStatus(upgradeToJavaClassesJSONObject, variableTypeName, methodName, parameterTypes);
            if (toUpgradeMethodStatus.equals((Object)MethodStatus.NO_CLASS_FOUND)) {
                this.log(methodCallDetailAST, _MSG_CLASS_NOT_FOUND, new Object[]{variableTypeName, upgradeToVersion});
                continue;
            }
            if (!toUpgradeMethodStatus.equals((Object)MethodStatus.NO_METHOD_FOUND)) continue;
            this.log(methodCallDetailAST, _MSG_METHOD_NOT_FOUND, new Object[]{methodName, variableTypeName, upgradeToVersion});
        }
    }

    private synchronized JSONObject _getJavaClassesJSONObject(String version) throws Exception {
        JSONObject javaClassesJSONObject = this._javaClassesJSONObjectMap.get(version);
        if (javaClassesJSONObject != null) {
            return javaClassesJSONObject;
        }
        JSONObject portalJSONObject = SourceFormatterUtil.getPortalJSONObjectByVersion(version);
        javaClassesJSONObject = portalJSONObject.has("javaClasses") ? portalJSONObject.getJSONObject("javaClasses") : new JSONObjectImpl();
        this._javaClassesJSONObjectMap.put(version, javaClassesJSONObject);
        return javaClassesJSONObject;
    }

    private MethodStatus _getMethodStatus(JSONObject jsonObject, String fullyQualifiedClassName, String methodName, List<String> parameterTypes) {
        JSONArray extendedClassNamesJSONArray;
        JSONObject classJSONObject = jsonObject.getJSONObject(fullyQualifiedClassName);
        if (classJSONObject == null) {
            return MethodStatus.NO_CLASS_FOUND;
        }
        JSONArray methodsJSONArray = classJSONObject.getJSONArray("methods");
        if (methodsJSONArray != null) {
            block0: for (JSONObject methodJSONObject : methodsJSONArray) {
                if (!methodName.equals(methodJSONObject.getString("name"))) continue;
                JSONArray parametersJSONArray = methodJSONObject.getJSONArray("parameters");
                if (parametersJSONArray == null) {
                    if (!parameterTypes.isEmpty()) continue;
                    return MethodStatus.METHOD_FOUND;
                }
                if (parametersJSONArray.length() != parameterTypes.size()) continue;
                for (int i = 0; i < parameterTypes.size(); ++i) {
                    String methodType;
                    String actualType = parameterTypes.get(i);
                    if (!StringUtil.equalsIgnoreCase(actualType, methodType = parametersJSONArray.getString(i)) && !methodType.equals("Object")) continue block0;
                }
                return MethodStatus.METHOD_FOUND;
            }
        }
        if ((extendedClassNamesJSONArray = classJSONObject.getJSONArray("extendedClassNames")) != null) {
            for (String extendedClassName : extendedClassNamesJSONArray) {
                if (extendedClassName.startsWith("com.liferay.") || !Objects.equals((Object)this._getMethodStatus(jsonObject, extendedClassName, methodName, parameterTypes), (Object)MethodStatus.METHOD_FOUND)) continue;
                return MethodStatus.METHOD_FOUND;
            }
        }
        return MethodStatus.NO_METHOD_FOUND;
    }

    private String _getParameterType(DetailAST detailAST) {
        if (detailAST.getType() == 58) {
            return this.getVariableTypeName(detailAST, detailAST.getText(), true, true);
        }
        if (detailAST.getType() == 139) {
            return "java.lang.String";
        }
        if (detailAST.getType() == 138) {
            return "char";
        }
        if (detailAST.getType() == 134 || detailAST.getType() == 133 || detailAST.getType() == 132) {
            return "boolean";
        }
        if (detailAST.getType() == 125) {
            DetailAST stringLiteralDetailAST = detailAST.findFirstToken(139);
            if (stringLiteralDetailAST != null) {
                return "java.lang.String";
            }
            return null;
        }
        if (detailAST.getType() == 136) {
            String parameterType = null;
            DetailAST firstChildDetailAST = detailAST.getFirstChild();
            parameterType = firstChildDetailAST.getType() == 58 ? firstChildDetailAST.getText() : this._getParameterType(firstChildDetailAST);
            if (parameterType == null) {
                return parameterType;
            }
            DetailAST curDetailAST = firstChildDetailAST.getNextSibling();
            while (true) {
                if (curDetailAST.getType() != 17) {
                    return parameterType;
                }
                parameterType = parameterType + "[]";
                curDetailAST = curDetailAST.getFirstChild();
            }
        }
        if (detailAST.getType() == 24) {
            String parameterType = this._getParameterType(detailAST.getFirstChild());
            if (parameterType != null) {
                parameterType = StringUtil.replaceLast(parameterType, "[]", "");
            }
            return parameterType;
        }
        if (detailAST.getType() == 23) {
            return this.getTypeName(detailAST, true, true);
        }
        if (ArrayUtil.contains(UNARY_OPERATOR_TOKEN_TYPES, detailAST.getType())) {
            return this._getParameterType(detailAST.getFirstChild());
        }
        if (detailAST.getType() == 78) {
            DetailAST parentDetailAST = this.getParentWithTokenType(detailAST, 14);
            if (parentDetailAST == null) {
                return null;
            }
            DetailAST identDetailAST = parentDetailAST.findFirstToken(58);
            return identDetailAST.getText();
        }
        if (ArrayUtil.contains(CONDITIONAL_OPERATOR_TOKEN_TYPES, detailAST.getType()) || ArrayUtil.contains(RELATIONAL_OPERATOR_TOKEN_TYPES, detailAST.getType())) {
            return "boolean";
        }
        if (detailAST.getType() == 142) {
            return "double";
        }
        if (detailAST.getType() == 140) {
            return "float";
        }
        if (detailAST.getType() == 141) {
            return "long";
        }
        if (detailAST.getType() == 137) {
            return "int";
        }
        if (detailAST.getType() == 50 || detailAST.getType() == 51 || detailAST.getType() == 57 || detailAST.getType() == 55 || detailAST.getType() == 54 || detailAST.getType() == 56 || detailAST.getType() == 53) {
            return detailAST.getText();
        }
        if (detailAST.getType() == 109) {
            return this._getParameterType(detailAST.getLastChild());
        }
        return null;
    }

    private List<String> _getParameterTypes(DetailAST detailAST) {
        ArrayList<String> parameterTypes = new ArrayList<String>();
        DetailAST elistDetailAST = detailAST.findFirstToken(34);
        List<DetailAST> exprDetailASTList = this.getAllChildTokens(elistDetailAST, false, 28);
        for (DetailAST exprDetailAST : exprDetailASTList) {
            parameterTypes.add(this._getParameterType(exprDetailAST.getFirstChild()));
        }
        return parameterTypes;
    }

    private List<String> _getRemovedImportNames(DetailAST detailAST, JSONObject fromUpgradeJavaClassesJSONObject, JSONObject toUpgradeJavaClassesJSONObject, String upgradeToVersion) {
        ArrayList<String> removedImportNames = new ArrayList<String>();
        List<String> importNames = this.getImportNames(detailAST);
        for (String importName : importNames) {
            JSONObject fromUpgradeClassJSONObject = fromUpgradeJavaClassesJSONObject.getJSONObject(importName);
            JSONObject toUpgradeClassJSONObject = toUpgradeJavaClassesJSONObject.getJSONObject(importName);
            if (fromUpgradeClassJSONObject == null || toUpgradeClassJSONObject != null) continue;
            this.log(detailAST, _MSG_CLASS_NOT_FOUND, new Object[]{importName, upgradeToVersion});
            removedImportNames.add(importName);
        }
        return removedImportNames;
    }

    private static enum MethodStatus {
        METHOD_FOUND,
        NO_CLASS_FOUND,
        NO_METHOD_FOUND;

    }
}

