/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.resource;

import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.Resource;
import net.sf.saxon.lib.ResourceFactory;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.resource.AbstractResourceCollection;
import net.sf.saxon.trans.XPathException;

public class XmlResource
implements Resource {
    private Source source;
    private ParseOptions options;
    private NodeInfo doc;
    private Configuration config;
    private int onError = 1;
    public static final ResourceFactory FACTORY = new ResourceFactory(){

        @Override
        public Resource makeResource(Configuration config, String resourceURI, String contentType, AbstractResourceCollection.InputDetails details) throws XPathException {
            StreamSource source = new StreamSource(details.inputStream, resourceURI);
            ParseOptions options = details.parseOptions;
            if (options == null) {
                options = config.getParseOptions();
            }
            return new XmlResource(config, source, options, details.onError);
        }
    };

    public XmlResource(NodeInfo doc) {
        this.config = doc.getConfiguration();
        this.doc = doc;
    }

    public XmlResource(Configuration config, NodeInfo doc) {
        this.config = config;
        this.doc = doc;
        if (config != doc.getConfiguration()) {
            throw new IllegalArgumentException("Supplied node belongs to wrong configuration");
        }
    }

    public XmlResource(Configuration config, Source source, ParseOptions options, int onError) {
        this.config = config;
        this.source = source;
        this.options = options;
        this.onError = onError;
    }

    @Override
    public String getResourceURI() {
        if (this.doc == null) {
            return this.source.getSystemId();
        }
        return this.doc.getSystemId();
    }

    public Item getItem(XPathContext context) throws XPathException {
        if (this.doc == null) {
            try {
                this.doc = this.config.buildDocumentTree(this.source, this.options).getRootNode();
            }
            catch (XPathException e) {
                if (this.onError == 1) {
                    XPathException e2 = new XPathException("collection(): failed to parse XML file " + this.source.getSystemId() + ": " + e.getMessage(), e.getErrorCodeLocalPart());
                    throw e2;
                }
                if (this.onError == 2) {
                    context.getController().warning("collection(): failed to parse XML file " + this.source.getSystemId() + ": " + e.getMessage(), e.getErrorCodeLocalPart(), null);
                }
                return null;
            }
            if (this.source instanceof StreamSource && ((StreamSource)this.source).getInputStream() != null) {
                try {
                    ((StreamSource)this.source).getInputStream().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return this.doc;
    }

    @Override
    public String getContentType() {
        return "application/xml";
    }
}

