/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;

public class MathUtil {
    private static final Log _log = LogFactoryUtil.getLog(MathUtil.class);
    private static final Map<Long, Integer> _base2LogValues = new HashMap<Long, Integer>(){
        {
            this.put(0L, Integer.MIN_VALUE);
            for (int i = 0; i < 63; ++i) {
                this.put(MathUtil.base2Pow(i), i);
            }
        }
    };

    public static int base2Log(long x) {
        return _base2LogValues.get(x);
    }

    public static long base2Pow(int x) {
        if (x == 0) {
            return 1L;
        }
        return 2L << x - 1;
    }

    public static int difference(Integer value1, Integer value2) {
        return value1 - value2;
    }

    public static int factorial(int x) {
        if (x < 0) {
            return 0;
        }
        int factorial = 1;
        while (x > 1) {
            factorial *= x;
            --x;
        }
        return factorial;
    }

    public static double format(double x, int max, int min) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(max);
        nf.setMinimumFractionDigits(min);
        try {
            Number number = nf.parse(nf.format(x));
            x = number.doubleValue();
        }
        catch (Exception exception) {
            _log.error(exception.getMessage());
        }
        return x;
    }

    public static int[] generatePrimes(int max) {
        if (max < 2) {
            return new int[0];
        }
        boolean[] crossedOut = new boolean[max + 1];
        for (int i = 2; i < crossedOut.length; ++i) {
            crossedOut[i] = false;
        }
        int limit = (int)Math.sqrt(crossedOut.length);
        for (int i = 2; i <= limit; ++i) {
            if (crossedOut[i]) continue;
            for (int multiple = 2 * i; multiple < crossedOut.length; multiple += i) {
                crossedOut[multiple] = true;
            }
        }
        int uncrossedCount = 0;
        for (int i = 2; i < crossedOut.length; ++i) {
            if (crossedOut[i]) continue;
            ++uncrossedCount;
        }
        int[] result = new int[uncrossedCount];
        int j = 0;
        for (int i = 2; i < crossedOut.length; ++i) {
            if (crossedOut[i]) continue;
            result[j++] = i;
        }
        return result;
    }

    public static boolean isEven(int x) {
        return x % 2 == 0;
    }

    public static boolean isOdd(int x) {
        return !MathUtil.isEven(x);
    }

    public static double product(Double ... values) {
        double product = 1.0;
        Double[] doubleArray = values;
        int n = doubleArray.length;
        for (int i = 0; i < n; ++i) {
            double value = doubleArray[i];
            product *= value;
        }
        return product;
    }

    public static int product(Integer ... values) {
        int product = 1;
        Integer[] integerArray = values;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int value = integerArray[i];
            product *= value;
        }
        return product;
    }

    public static long product(Long ... values) {
        long product = 1L;
        Long[] longArray = values;
        int n = longArray.length;
        for (int i = 0; i < n; ++i) {
            long value = longArray[i];
            product *= value;
        }
        return product;
    }

    public static int quotient(Integer value1, Integer value2) {
        return value1 / value2;
    }

    public static double sum(Double ... values) {
        double sum = 0.0;
        Double[] doubleArray = values;
        int n = doubleArray.length;
        for (int i = 0; i < n; ++i) {
            double value = doubleArray[i];
            sum += value;
        }
        return sum;
    }

    public static int sum(Integer ... values) {
        int sum = 0;
        Integer[] integerArray = values;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int value = integerArray[i];
            sum += value;
        }
        return sum;
    }

    public static long sum(Long ... values) {
        long sum = 0L;
        Long[] longArray = values;
        int n = longArray.length;
        for (int i = 0; i < n; ++i) {
            long value = longArray[i];
            sum += value;
        }
        return sum;
    }
}

