/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.pql;

import com.liferay.poshi.core.pql.PQLEntity;
import com.liferay.poshi.core.pql.PQLQuery;
import com.liferay.poshi.core.pql.PQLValue;
import com.liferay.poshi.core.pql.PQLVariable;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class PQLEntityFactory {
    private static final Map<Character, Character> _codeBoundariesMap = new HashMap<Character, Character>(){
        {
            this.put(Character.valueOf('('), Character.valueOf(')'));
            this.put(Character.valueOf('\"'), Character.valueOf('\"'));
        }
    };

    public static PQLEntity newPQLEntity(String pql) throws Exception {
        if (pql != null) {
            PQLEntityFactory.validateExpressionBalance(pql);
        }
        if (PQLQuery.isQuery(pql)) {
            return new PQLQuery(pql);
        }
        if (PQLVariable.isVariable(pql)) {
            return new PQLVariable(pql);
        }
        return new PQLValue(pql);
    }

    public static void validateExpressionBalance(String pql) {
        Stack<Integer> stack = new Stack<Integer>();
        for (int i = 0; i < pql.length(); ++i) {
            char c = pql.charAt(i);
            if (!stack.isEmpty()) {
                int topIndex = (Integer)stack.peek();
                Character topCodeBoundary = Character.valueOf(pql.charAt(topIndex));
                if (c == _codeBoundariesMap.get(topCodeBoundary).charValue()) {
                    stack.pop();
                    continue;
                }
                if (topCodeBoundary.charValue() == '\"') continue;
            }
            if (_codeBoundariesMap.containsKey(Character.valueOf(c))) {
                stack.push(i);
                continue;
            }
            if (!_codeBoundariesMap.containsValue(Character.valueOf(c))) continue;
            throw new RuntimeException("Invalid PQL: Unexpected closing boundary '" + pql.charAt(i) + "'\n" + pql);
        }
        if (!stack.isEmpty()) {
            throw new RuntimeException("Invalid PQL: Unmatched opening boundary '" + pql.charAt((Integer)stack.peek()) + "'\n" + pql);
        }
    }
}

