/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.prose;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PoshiProseMatcher {
    protected static final Map<String, PoshiProseMatcher> poshiProseMatcherMap = new HashMap<String, PoshiProseMatcher>();
    private static final Pattern _alternateTextPattern = Pattern.compile("(.*?)(?<alternateText1>\\w+)\\/(?<alternateText2>\\w+)(.*)");
    private static final Pattern _optionalTextPattern = Pattern.compile("(.*?)\\((?<optionalText>.*?)\\)(.*)");
    private static final Pattern _poshiProseVarPattern = Pattern.compile("\\$\\{(.+?)\\}");
    private final String _macroNamespacedClassCommandName;
    private final String _poshiProse;
    private final List<String> _varNames = new ArrayList<String>();

    public static PoshiProseMatcher getPoshiProseMatcher(String poshiProse) {
        String key = PoshiProseMatcher._toString(poshiProse);
        return poshiProseMatcherMap.get(key);
    }

    public static void storePoshiProseMatcher(String poshiProse, String macroNamespacedClassCommandName) throws Exception {
        List<String> possiblePoshiProseStrings = PoshiProseMatcher._getPossiblePoshiProseStrings(poshiProse);
        for (String possiblePoshiProseString : possiblePoshiProseStrings) {
            String key = PoshiProseMatcher._toString(possiblePoshiProseString);
            PoshiProseMatcher ppm = poshiProseMatcherMap.get(key);
            if (ppm != null && !macroNamespacedClassCommandName.equals(ppm.getMacroNamespacedClassCommandName())) {
                StringBuilder sb = new StringBuilder();
                sb.append("Duplicate prose '");
                sb.append(key);
                sb.append("' already exists for ");
                sb.append(ppm.getMacroNamespacedClassCommandName());
                sb.append("\n in ");
                sb.append(macroNamespacedClassCommandName);
                throw new RuntimeException(sb.toString());
            }
            poshiProseMatcherMap.put(key, new PoshiProseMatcher(poshiProse, macroNamespacedClassCommandName));
        }
    }

    public String getMacroNamespacedClassCommandName() {
        return this._macroNamespacedClassCommandName;
    }

    public String getPoshiProse() {
        return this._poshiProse;
    }

    public List<String> getVarNames() {
        return this._varNames;
    }

    public String toString() {
        return PoshiProseMatcher._toString(this._poshiProse);
    }

    private static List<String> _getPossibleAlternateStrings(String proseString) {
        ArrayList<String> possibleAlternateStrings = new ArrayList<String>();
        if (proseString == null) {
            return possibleAlternateStrings;
        }
        Matcher alternateTextMatcher = _alternateTextPattern.matcher(proseString);
        if (alternateTextMatcher.find()) {
            ArrayList<String> possiblePrefixes = new ArrayList<String>();
            possiblePrefixes.add(alternateTextMatcher.group(1) + alternateTextMatcher.group("alternateText1"));
            possiblePrefixes.add(alternateTextMatcher.group(1) + alternateTextMatcher.group("alternateText2"));
            List<String> possiblePostfixes = PoshiProseMatcher._getPossibleAlternateStrings(alternateTextMatcher.group(4));
            for (String possiblePrefix : possiblePrefixes) {
                for (String possiblePostfix : possiblePostfixes) {
                    possibleAlternateStrings.add(possiblePrefix + possiblePostfix);
                }
            }
        } else {
            possibleAlternateStrings.add(proseString);
        }
        return possibleAlternateStrings;
    }

    private static List<String> _getPossibleOptionalStrings(String proseString) {
        ArrayList<String> possibleOptionalStrings = new ArrayList<String>();
        if (proseString == null) {
            return possibleOptionalStrings;
        }
        Matcher optionalTextMatcher = _optionalTextPattern.matcher(proseString);
        if (optionalTextMatcher.find()) {
            ArrayList<String> possiblePrefixes = new ArrayList<String>();
            possiblePrefixes.add(optionalTextMatcher.group(1));
            possiblePrefixes.add(optionalTextMatcher.group(1) + optionalTextMatcher.group("optionalText"));
            List<String> possiblePostfixes = PoshiProseMatcher._getPossiblePoshiProseStrings(optionalTextMatcher.group(3));
            for (String possiblePrefix : possiblePrefixes) {
                for (String possibleSecondPartString : possiblePostfixes) {
                    possibleOptionalStrings.add(possiblePrefix + possibleSecondPartString);
                }
            }
        } else {
            possibleOptionalStrings.add(proseString);
        }
        return possibleOptionalStrings;
    }

    private static List<String> _getPossiblePoshiProseStrings(String proseString) {
        ArrayList<String> possiblePoshiProseStrings = new ArrayList<String>();
        if (proseString == null) {
            return possiblePoshiProseStrings;
        }
        List<String> possibleAlternateStrings = PoshiProseMatcher._getPossibleAlternateStrings(proseString);
        for (String possibleAlternateString : possibleAlternateStrings) {
            possiblePoshiProseStrings.addAll(PoshiProseMatcher._getPossibleOptionalStrings(possibleAlternateString));
        }
        return possiblePoshiProseStrings;
    }

    private static String _toString(String matchingString) {
        return matchingString.replaceAll("\\$\\{.+?\\}", "\"\"");
    }

    private PoshiProseMatcher(String poshiProse, String macroNamespacedClassCommandName) {
        this._poshiProse = poshiProse;
        this._macroNamespacedClassCommandName = macroNamespacedClassCommandName;
        Matcher matcher = _poshiProseVarPattern.matcher(this._poshiProse);
        while (matcher.find()) {
            this._varNames.add(matcher.group(1));
        }
    }
}

