/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.BNDSettings;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.io.IOException;

public class PackageinfoBNDExportPackageCheck
extends BaseFileCheck {
    @Override
    public boolean isModuleSourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (absolutePath.contains("/src/main/resources/") && !this._hasBNDExportPackage(fileName)) {
            return null;
        }
        return content;
    }

    private boolean _hasBNDExportPackage(String fileName) throws IOException {
        BNDSettings bndSettings = this.getBNDSettings(fileName);
        if (bndSettings == null) {
            return false;
        }
        for (String exportPackageName : bndSettings.getExportPackageNames()) {
            String suffix = StringBundler.concat("/src/main/resources/", StringUtil.replace(exportPackageName, '.', '/'), "/packageinfo");
            if (!fileName.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }
}

