/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.comparator.ElementComparator;
import com.liferay.source.formatter.checks.util.SourceUtil;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class XMLFriendlyURLRoutesFileCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws DocumentException {
        if (fileName.endsWith("routes.xml")) {
            this._checkOrder(fileName, content);
        }
        return content;
    }

    private void _checkOrder(String fileName, String content) throws DocumentException {
        Document document = SourceUtil.readXML(content);
        Element rootElement = document.getRootElement();
        List routeElements = rootElement.elements("route");
        ElementComparator elementComparator = new ElementComparator();
        for (Element routeElement : routeElements) {
            this.checkElementOrder(fileName, routeElement, "ignored-parameter", null, elementComparator);
            this.checkElementOrder(fileName, routeElement, "implicit-parameter", null, elementComparator);
            this.checkElementOrder(fileName, routeElement, "overridden-parameter", null, elementComparator);
        }
    }
}

