/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.elements;

import com.liferay.poshi.core.PoshiContext;
import com.liferay.poshi.core.elements.PoshiElement;
import com.liferay.poshi.core.elements.PoshiElementAttribute;
import com.liferay.poshi.core.elements.PoshiNode;
import com.liferay.poshi.core.elements.PoshiNodeFactory;
import com.liferay.poshi.core.elements.ReturnPoshiElement;
import com.liferay.poshi.core.script.PoshiScriptParserException;
import com.liferay.poshi.core.util.ListUtil;
import com.liferay.poshi.core.util.NaturalOrderStringComparator;
import com.liferay.poshi.core.util.RegexUtil;
import com.liferay.poshi.core.util.StringUtil;
import com.liferay.poshi.core.util.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Node;

public class ExecutePoshiElement
extends PoshiElement {
    private static final String _ELEMENT_NAME = "execute";
    private static final String _UTILITY_INVOCATION_REGEX = "(echo|fail|takeScreenshot)\\(.*?\\)";
    private static final Pattern _executeParameterPattern = Pattern.compile("^[\\s]*(\\w*\\s*=\\s*\"[ \\t\\S]*?\"|\\w*\\s*=\\s*'''.*?'''|\\w*\\s=\\s*[\\w\\.]*\\(.*?\\))[\\s]*$", 32);
    private static final List<String> _functionAttributeNames = Arrays.asList("locator1", "locator2", "value1", "value2", "value3");
    private static final Pattern _statementPattern = Pattern.compile("^" + INVOCATION_REGEX + ";$", 32);
    private static final Pattern _utilityInvocationStatementPattern = Pattern.compile("^(echo|fail|takeScreenshot)\\(.*?\\);$");

    @Override
    public PoshiElement clone(Element element) {
        if (this.isElementType(_ELEMENT_NAME, element)) {
            return new ExecutePoshiElement(element);
        }
        return null;
    }

    @Override
    public PoshiElement clone(PoshiElement parentPoshiElement, String poshiScript) throws PoshiScriptParserException {
        if (this._isElementType(parentPoshiElement, poshiScript)) {
            return new ExecutePoshiElement(parentPoshiElement, poshiScript);
        }
        return null;
    }

    @Override
    public void parsePoshiScript(String poshiScript) throws PoshiScriptParserException {
        String poshiScriptParentheticalContent = this.getParentheticalContent(poshiScript);
        String fileExtension = this.getFileExtension();
        if (fileExtension.equals("function") && poshiScript.startsWith("selenium.")) {
            this.addAttribute("selenium", this.getCommandName(poshiScript));
            List<String> methodParameters = this.getMethodParameters(poshiScriptParentheticalContent);
            for (int i = 0; i < methodParameters.size(); ++i) {
                String methodParameter = methodParameters.get(i);
                String string = this.getDoubleQuotedContent(methodParameter);
                this.addAttribute("argument" + (i + 1), string);
            }
            return;
        }
        String executeCommandName = RegexUtil.getGroup(poshiScript, "([^\\s]*?)\\(", 1);
        boolean namespacedCommandName = false;
        for (String string : PoshiContext.getNamespaces()) {
            if (!executeCommandName.startsWith(string + ".")) continue;
            namespacedCommandName = true;
            break;
        }
        if (namespacedCommandName) {
            int index = executeCommandName.indexOf(".");
            String string = executeCommandName.substring(0, index);
            executeCommandName = StringUtil.replace(executeCommandName, string + ".", "");
            executeCommandName = StringUtil.replace(executeCommandName, '.', '#');
            executeCommandName = string + "." + executeCommandName;
        } else {
            executeCommandName = StringUtil.replace(executeCommandName, '.', '#');
        }
        if (this.isValidFunctionFileName(poshiScript)) {
            this.addAttribute("function", executeCommandName);
        } else if (this.isValidMacroFileName(poshiScript)) {
            PoshiNode<?, ?> returnPoshiNode;
            this.addAttribute("macro", executeCommandName);
            if (poshiScript.startsWith("var ") && (returnPoshiNode = PoshiNodeFactory.newPoshiNode(this, poshiScript)) instanceof ReturnPoshiElement) {
                this.add(returnPoshiNode);
            }
        } else {
            this.addAttribute("class", this.getClassName(poshiScript));
            this.addAttribute("method", this.getCommandName(poshiScript));
            List<String> methodParameters = this.getMethodParameters(poshiScriptParentheticalContent);
            for (String methodParameter : methodParameters) {
                this.add(PoshiNodeFactory.newPoshiNode(this, methodParameter));
            }
            return;
        }
        for (String string : this.getMethodParameters(poshiScriptParentheticalContent, _executeParameterPattern)) {
            String string2 = string.trim();
            boolean functionAttributeAdded = false;
            for (String functionAttributeName : _functionAttributeNames) {
                String name = this.getNameFromAssignment(string2);
                if (!name.equals(functionAttributeName)) continue;
                String value = this.getValueFromAssignment(string2);
                Matcher matcher = quotedPattern.matcher(value);
                if (!matcher.matches()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Invalid function parameter syntax, must ");
                    sb.append("match: (locator|value)(1|2) = \".*\"");
                    throw new PoshiScriptParserException(sb.toString(), string2, (PoshiElement)this.getParent());
                }
                value = this.getDoubleQuotedContent(value);
                value = StringEscapeUtils.unescapeXml((String)value);
                this.add((Attribute)new PoshiElementAttribute(name, value, string2));
                functionAttributeAdded = true;
                break;
            }
            if (functionAttributeAdded) continue;
            this.add(PoshiNodeFactory.newPoshiNode(this, string2));
        }
    }

    @Override
    public String toPoshiScript() {
        ArrayList<String> assignments = new ArrayList<String>();
        for (PoshiElementAttribute poshiElementAttribute : this.toPoshiElementAttributes(this.attributes())) {
            String poshiElementAttributeName = poshiElementAttribute.getName();
            if (poshiElementAttributeName.equals("class") || poshiElementAttributeName.equals("function") || poshiElementAttributeName.equals("macro") || poshiElementAttributeName.equals("method") || poshiElementAttributeName.equals("selenium")) continue;
            String fileExtension = this.getFileExtension();
            if (fileExtension.equals("function") && Validator.isNotNull(this.attributeValue("selenium"))) {
                String poshiElementAttributeValue = poshiElementAttribute.getValue();
                assignments.add(this.doubleQuoteContent(poshiElementAttributeValue));
                continue;
            }
            String poshiScript = poshiElementAttribute.toPoshiScript();
            assignments.add(poshiScript.trim());
        }
        ReturnPoshiElement returnPoshiElement = null;
        for (PoshiElement poshiElement : this.toPoshiElements(this.elements())) {
            if (poshiElement instanceof ReturnPoshiElement) {
                returnPoshiElement = (ReturnPoshiElement)poshiElement;
                continue;
            }
            String poshiScript = poshiElement.toPoshiScript();
            assignments.add(poshiScript.trim());
        }
        String string = this.createPoshiScriptSnippet(assignments);
        if (returnPoshiElement == null) {
            return string;
        }
        return returnPoshiElement.createPoshiScriptSnippet(string);
    }

    protected ExecutePoshiElement() {
        this(_ELEMENT_NAME);
    }

    protected ExecutePoshiElement(Element element) {
        super(_ELEMENT_NAME, element);
    }

    protected ExecutePoshiElement(List<Attribute> attributes, List<Node> nodes) {
        this(_ELEMENT_NAME, attributes, nodes);
    }

    protected ExecutePoshiElement(PoshiElement parentPoshiElement, String poshiScript) throws PoshiScriptParserException {
        super(_ELEMENT_NAME, parentPoshiElement, poshiScript);
    }

    protected ExecutePoshiElement(String name) {
        super(name);
    }

    protected ExecutePoshiElement(String name, Element element) {
        super(name, element);
    }

    protected ExecutePoshiElement(String elementName, List<Attribute> attributes, List<Node> nodes) {
        super(elementName, attributes, nodes);
    }

    protected ExecutePoshiElement(String name, PoshiElement parentPoshiElement, String poshiScript) throws PoshiScriptParserException {
        super(name, parentPoshiElement, poshiScript);
    }

    protected String createPoshiScriptSnippet(List<String> assignments) {
        StringBuilder sb = new StringBuilder();
        String pad = this.getPad();
        sb.append("\n\n");
        sb.append(pad);
        sb.append(StringUtil.replace(this.getBlockName(), '#', '.'));
        sb.append("(");
        boolean multilineSnippet = false;
        String assignmentsString = ListUtil.toString(assignments);
        if (assignments.size() > 1 && assignmentsString.matches("(?s)\\w+\\s*=.+") && !this.isConditionValidInParent((PoshiElement)this.getParent())) {
            multilineSnippet = true;
        }
        Collections.sort(assignments, new Comparator<String>(){

            @Override
            public int compare(String assignment1, String assignment2) {
                if (!assignment1.matches("\\w+ = .+") && !assignment2.matches("\\w+ = .+")) {
                    return 0;
                }
                String name1 = assignment1.substring(0, assignment1.indexOf(61));
                String name2 = assignment2.substring(0, assignment2.indexOf(61));
                NaturalOrderStringComparator naturalOrderStringComparator = new NaturalOrderStringComparator();
                return naturalOrderStringComparator.compare(name1, name2);
            }
        });
        for (String assignment : assignments) {
            String s = sb.toString();
            s = s.substring(s.lastIndexOf("\n"));
            if (multilineSnippet) {
                if (s.endsWith(" ")) {
                    sb.setLength(sb.length() - 1);
                }
                sb.append("\n\t");
                sb.append(pad);
            }
            sb.append(assignment);
            sb.append(", ");
        }
        if (!assignments.isEmpty()) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(");");
        return sb.toString();
    }

    @Override
    protected String getBlockName() {
        if (this.attributeValue("class") != null) {
            return this.attributeValue("class") + "." + this.attributeValue("method");
        }
        if (this.attributeValue("function") != null) {
            return this.attributeValue("function");
        }
        if (this.attributeValue("macro") != null) {
            return this.attributeValue("macro");
        }
        return "selenium." + this.attributeValue("selenium");
    }

    private boolean _isElementType(PoshiElement parentPoshiElement, String poshiScript) {
        if (parentPoshiElement instanceof ExecutePoshiElement) {
            return false;
        }
        if ((this.isVarAssignedToMacroInvocation(poshiScript) || this.isValidPoshiScriptStatement(_statementPattern, poshiScript)) && !this.isValidPoshiScriptStatement(_utilityInvocationStatementPattern, poshiScript)) {
            return this.isBalancedPoshiScript(this.getParentheticalContent(poshiScript));
        }
        return false;
    }
}

