/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.pql;

import com.liferay.poshi.core.pql.PQLEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public abstract class PQLOperator {
    private static final Set<String> _availableOperators = new HashSet<String>();
    private static final List<List<String>> _prioritizedOperatorList = new ArrayList<List<String>>(){
        {
            this.add(Arrays.asList("<", ">"));
            this.add(Arrays.asList("<=", ">="));
            this.add(Arrays.asList("~", "=="));
            this.add(Arrays.asList("!~", "!="));
            this.add(Arrays.asList("OR"));
            this.add(Arrays.asList("AND"));
        }
    };
    private final String _operator;

    public static Set<String> getAvailableOperators() {
        return _availableOperators;
    }

    public static List<List<String>> getPrioritizedOperatorList() {
        return _prioritizedOperatorList;
    }

    public static void validateOperator(String operator) throws Exception {
        if (operator == null || !_availableOperators.contains(operator)) {
            throw new Exception("Invalid operator: " + operator);
        }
    }

    public PQLOperator(String operator) throws Exception {
        PQLOperator.validateOperator(operator);
        this._operator = operator;
    }

    public String getOperator() {
        return this._operator;
    }

    public abstract Object getPQLResult(PQLEntity var1, PQLEntity var2, Properties var3) throws Exception;

    static {
        for (List<String> operators : _prioritizedOperatorList) {
            _availableOperators.addAll(operators);
        }
    }
}

