/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.pql;

import com.liferay.poshi.core.PoshiContext;
import com.liferay.poshi.core.pql.PQLValue;
import java.util.List;
import java.util.Properties;

public class PQLVariable
extends PQLValue {
    public static boolean isVariable(String variable) {
        if (variable == null) {
            return false;
        }
        List<String> poshiPropertyNames = PoshiContext.getPoshiPropertyNames();
        return poshiPropertyNames.contains(variable);
    }

    public PQLVariable(String variable) throws Exception {
        super(variable);
        this._validateVariable(this.getPQL());
    }

    @Override
    public Object getPQLResult(Properties properties) throws Exception {
        String pql = this.getPQL();
        if (!properties.containsKey(pql)) {
            return null;
        }
        String value = properties.getProperty(pql);
        if (!(value.startsWith("'") && value.endsWith("'") || value.startsWith("\"") && value.endsWith("\"") || !value.contains(" "))) {
            value = "'" + value + "'";
        }
        return this.getObjectValue(value);
    }

    private void _validateVariable(String variable) throws Exception {
        if (variable == null) {
            throw new Exception("Invalid variable: " + variable);
        }
        variable.trim();
        if (!PQLVariable.isVariable(variable)) {
            throw new Exception("Invalid testcase property: " + variable);
        }
    }
}

