/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EmptyCollectionCheck
extends BaseFileCheck {
    private static final Pattern _emptyCollectionPattern = Pattern.compile("Collections\\.EMPTY_(LIST|MAP|SET)");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        Matcher matcher = _emptyCollectionPattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String replacement = StringBundler.concat("Collections.empty", TextFormatter.format(matcher.group(1), 9), "()");
        return StringUtil.replace(content, matcher.group(), replacement);
    }
}

