/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.JSPSourceProcessor;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IfStatementCheck
extends BaseFileCheck {
    private static final Pattern _assignStatementPattern = Pattern.compile("^(\\w+) =[^;]+;$");
    private static final Pattern _ifStatementPattern = Pattern.compile("[\n\t]if \\(");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        Matcher matcher = _ifStatementPattern.matcher(content);
        while (matcher.find()) {
            IfStatement ifStatement2;
            String newContent;
            IfStatement ifStatement1;
            if (!this.isJavaSource(content, matcher.start()) || (ifStatement1 = this._getIfStatement(content, matcher.start())) == null) continue;
            String followingCode = ifStatement1.getFollowingCode();
            if (!followingCode.startsWith("//") && !followingCode.startsWith("else ") && Validator.isNull(ifStatement1.getBody())) {
                this.addMessage(fileName, "If-statement with empty body", this.getLineNumber(content, matcher.start()));
            }
            if (!followingCode.startsWith("if (") || content.equals(newContent = this._combineStatementsWithSameBodies(content, ifStatement1, ifStatement2 = this._getIfStatement(content, ifStatement1.getEnd())))) continue;
            if (this.getSourceProcessor() instanceof JSPSourceProcessor) {
                this.addMessage(fileName, "Merge consecutive if-statements when executing identical code", this.getLineNumber(content, matcher.start()));
                continue;
            }
            return newContent;
        }
        return content;
    }

    private String _combineStatementsWithSameBodies(String content, IfStatement ifStatement1, IfStatement ifStatement2) {
        int count;
        String clause;
        String body = ifStatement1.getBody();
        if (!body.equals(ifStatement2.getBody())) {
            return content;
        }
        Matcher matcher = _assignStatementPattern.matcher(body);
        if (matcher.find() ? (clause = ifStatement2.getClause()).matches("(?s).*\\W" + matcher.group(1) + "\\W.*") : !body.matches("(?s)(.+\t)?(break|continue|return|throw)(\\s|;).*")) {
            return content;
        }
        String followingCode = ifStatement2.getFollowingCode();
        if (followingCode.startsWith("//") || followingCode.startsWith("else ")) {
            return content;
        }
        String combinedStatements = StringBundler.concat("if (", ifStatement1.getClause(), " || ", ifStatement2.getClause(), ") {\n", ifStatement1.getBody(), "\n}\n");
        if (combinedStatements.contains("&&") && (count = StringUtil.count(combinedStatements, "||") + StringUtil.count(combinedStatements, "&&")) > 2) {
            return content;
        }
        String consecutiveStatements = content.substring(ifStatement1.getStart(), ifStatement2.getEnd());
        return StringUtil.replace(content, consecutiveStatements, combinedStatements, ifStatement1.getStart() - 1);
    }

    private int _getClosePos(String content, String openChar, String closeChar, int start) {
        int level;
        int closePos = start;
        do {
            if ((closePos = content.indexOf(closeChar, closePos + 1)) == -1) {
                return -1;
            }
            String s = content.substring(start, closePos + 1);
            level = this.getLevel(s, openChar, closeChar);
            if (level != 0) continue;
            return closePos;
        } while (level != -1);
        return -1;
    }

    private IfStatement _getIfStatement(String content, int pos) {
        int x = this._getClosePos(content, "(", ")", pos);
        if (x == -1 || !Objects.equals(content.substring(x, x + 3), ") {")) {
            return null;
        }
        int y = this._getClosePos(content, "{", "}", x + 1);
        if (y == -1) {
            return null;
        }
        return new IfStatement(StringUtil.trim(content.substring(x + 3, y)), content.substring(content.indexOf("(", pos), x + 1), StringUtil.trim(content.substring(y + 1)), pos, y + 1);
    }

    private class IfStatement {
        private final String _body;
        private final String _clause;
        private final int _end;
        private final String _followingCode;
        private final int _start;

        public IfStatement(String body, String clause, String followingCode, int start, int end) {
            this._body = body;
            this._clause = clause;
            this._followingCode = followingCode;
            this._start = start;
            this._end = end;
        }

        public String getBody() {
            return this._body;
        }

        public String getClause() {
            return this._clause;
        }

        public int getEnd() {
            return this._end;
        }

        public String getFollowingCode() {
            return this._followingCode;
        }

        public int getStart() {
            return this._start;
        }
    }
}

