/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MarkdownStylingCheck
extends BaseFileCheck {
    private static final Pattern _boldHeaderPattern = Pattern.compile("(\\A|\n)(#+ ?)(\\*+)([^\\*\n]+)(\\*+)(\n)");
    private static final Pattern _incorrectCodeSyntaxPattern = Pattern.compile("\\S.*```|```.* ");
    private static final Pattern _incorrectHeaderNotationPattern = Pattern.compile("(\\A|\n)(#+[^#\n]+)(#+)(\n)");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        content = this._formatCodeSyntax(content);
        return this._formatHeaders(content);
    }

    private String _formatCodeSyntax(String content) {
        Matcher matcher = _incorrectCodeSyntaxPattern.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, "```", "`", matcher.start());
        }
        return content;
    }

    private String _formatHeaders(String content) {
        Matcher matcher = _incorrectHeaderNotationPattern.matcher(content);
        content = matcher.replaceAll("$1$2$4");
        matcher = _boldHeaderPattern.matcher(content);
        return matcher.replaceAll("$1$2$4$6");
    }
}

