/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class XMLWebFileCheck
extends BaseFileCheck {
    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (fileName.endsWith("portal-web/docroot/WEB-INF/web.xml")) {
            content = this._formatSecurityConstraints(content, this._getURLPatterns(absolutePath));
        } else if (fileName.endsWith("portal-web/docroot/WEB-INF/shielded-container-web.xml")) {
            content = this._formatServletMappings(content, this._getURLPatterns(absolutePath));
        }
        return content;
    }

    private String _formatSecurityConstraints(String content, Set<String> urlPatterns) {
        int x = content.indexOf("<security-constraint>");
        if (x == -1) {
            return content;
        }
        if ((x = content.indexOf("<web-resource-collection>", x)) == -1) {
            return content;
        }
        if ((x = content.indexOf("<url-pattern>", x)) == -1) {
            return content;
        }
        int y = content.indexOf("</web-resource-collection>", x - 3);
        if (y == -1) {
            return content;
        }
        if ((y = content.lastIndexOf("</url-pattern>", y)) == -1) {
            return content;
        }
        StringBundler sb = new StringBundler(3 * urlPatterns.size() + 1);
        sb.append("\t\t\t<url-pattern>/c/portal/protected</url-pattern>\n");
        for (String urlPattern : urlPatterns) {
            sb.append("\t\t\t<url-pattern>/");
            sb.append(urlPattern);
            sb.append("/c/portal/protected</url-pattern>\n");
        }
        return StringBundler.concat(content.substring(0, x - 3), sb.toString(), content.substring(y + 15));
    }

    private String _formatServletMappings(String content, Set<String> urlPatterns) {
        StringBundler sb = new StringBundler(6 * urlPatterns.size());
        for (String urlPattern : urlPatterns) {
            sb.append("\t<servlet-mapping>\n");
            sb.append("\t\t<servlet-name>I18n Servlet</servlet-name>\n");
            sb.append("\t\t<url-pattern>/");
            sb.append(urlPattern);
            sb.append("/*</url-pattern>\n");
            sb.append("\t</servlet-mapping>\n");
        }
        int x = content.indexOf("<servlet-mapping>");
        if (x == -1) {
            return content;
        }
        if ((x = content.indexOf("<servlet-name>I18n Servlet</servlet-name>", x)) == -1) {
            return content;
        }
        x = content.lastIndexOf("<servlet-mapping>", x) - 1;
        int y = content.lastIndexOf("<servlet-name>I18n Servlet</servlet-name>");
        if (y == -1) {
            return content;
        }
        if ((y = content.indexOf("</servlet-mapping>", y)) == -1) {
            return content;
        }
        return StringBundler.concat(content.substring(0, x), sb.toString(), content.substring(y + 19));
    }

    private Set<String> _getURLPatterns(String absolutePath) throws IOException {
        Properties properties = new Properties();
        PropertiesUtil.load(properties, this.getPortalContent("portal-impl/src/portal.properties", absolutePath));
        Object[] locales = StringUtil.split(properties.getProperty("locales"));
        Arrays.sort(locales);
        TreeSet<String> urlPatterns = new TreeSet<String>();
        for (Object locale : locales) {
            int pos = ((String)locale).indexOf(95);
            String languageCode = ((String)locale).substring(0, pos);
            urlPatterns.add(languageCode);
            urlPatterns.add((String)locale);
            urlPatterns.add(StringUtil.replaceFirst((String)locale, '_', '-'));
        }
        return urlPatterns;
    }
}

